<?php

/**
 * Products, Quotations & Invoices modules.
 * Extensions to SugarCRM
 * @package Advanced OpenSales for SugarCRM
 * @subpackage Products
 * @copyright SalesAgility Ltd http://www.salesagility.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU AFFERO GENERAL PUBLIC LICENSE
 * along with this program; if not, see http://www.gnu.org/licenses
 * or write to the Free Software Foundation,Inc., 51 Franklin Street,
 * Fifth Floor, Boston, MA 02110-1301  USA
 *
 * @author Salesagility Ltd <support@salesagility.com>
 */
require_once('include/MVC/Controller/SugarController.php');

class stu_tallasController extends SugarController {

    /**
     * Esta accion se encarga de obtener los datos complementarios para el contacto
     * Raul .A Alzate
     * 
     * @param id del usario
     * @return Json de datos
     */
    function action_getDataTallas() {
        $params = $_POST;
        $id = $params['billing_contact_id'];
        $query = "SELECT 
            phone_mobile, 
            phone_home, 
            primary_address_street, 
            barrios_c,
            gea_zonas_id_c, 
            gea_zonas.name as nombre_zona,
            gea_barrios.name as nombre_barrio,
            contacts_cstm.referencia1_c,
            contacts_cstm.referencia1_tel_c,
            contacts_cstm.referencia1_cel_c,
	    contacts_cstm.cedula_nit_c,
            sum(gea_cartera.saldo) AS saldo
            FROM contacts JOIN contacts_cstm ON contacts.id = contacts_cstm.id_c
            LEFT JOIN gea_zonas ON gea_zonas.id = gea_zonas_id_c
            LEFT JOIN gea_barrios ON gea_barrios.id = gea_barrios_id_c
            LEFT JOIN contacts_gea_cartera_1_c ON contacts_gea_cartera_1_c.contacts_gea_cartera_1contacts_ida = contacts.id
            left join gea_cartera on gea_cartera.id = contacts_gea_cartera_1_c.contacts_gea_cartera_1gea_cartera_idb
            WHERE contacts.id ='$id' AND gea_cartera.deleted = 0";
        $result = $this->bean->db->query($query, true);
        $row = $this->bean->db->fetchByAssoc($result);
        header("Content-type: application/json");
        echo json_encode($row);
        exit;
    }

    public function action_getDatosTest() {
        $query = "SELECT 
            name FROM stu_tallas ";
        $result = $this->bean->db->query($query, true);

        var_dump($result);
    }

}

?>