<?php
/**
 * Products, Quotations & Invoices modules.
 * Extensions to SugarCRM
 * @package Advanced OpenSales for SugarCRM
 * @subpackage Products
 * @copyright SalesAgility Ltd http://www.salesagility.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU AFFERO GENERAL PUBLIC LICENSE
 * along with this program; if not, see http://www.gnu.org/licenses
 * or write to the Free Software Foundation,Inc., 51 Franklin Street,
 * Fifth Floor, Boston, MA 02110-1301  USA
 *
 * @author Salesagility Ltd <support@salesagility.com>
 */

/**
 * THIS CLASS IS FOR DEVELOPERS TO MAKE CUSTOMIZATIONS IN
 */
require_once('modules/AOS_Products/AOS_Products_sugar.php');
class AOS_Products extends AOS_Products_sugar {
	
	function AOS_Products(){	
		parent::AOS_Products_sugar();
	}
    /*function create_new_list_query($order_by, $where, $filter = array(), $params = array(), $show_deleted = 0, $join_type = '', $return_array = false, $parentbean = null, $singleSelect = false, $ifListForExport = false) {
        $ret_array= parent::create_new_list_query($order_by, $where, $filter, $params, $show_deleted, $join_type, $return_array, $parentbean, $singleSelect, $ifListForExport);
        //$ret_array['select'] .= " ,aos_products.product_image";
        
        print "<pre>";print_r($ret_array);print "</pre>";die;
        return $ret_array; 
    }*/
	
        
    function save($check_notify=false){
        global $sugar_config,$mod_strings;
        if ($_POST['deleteAttachment']=='1') {
            $this->product_image = '';
	}
        require_once('include/upload_file.php');
	$GLOBALS['log']->debug('UPLOADING PRODUCT IMAGE');
	$upload_file = new UploadFile('uploadfile');

	if (isset($_FILES['uploadimage']['tmp_name'])&&$_FILES['uploadimage']['tmp_name']!=""){

            if($_FILES['uploadimage']['size'] > $sugar_config['upload_maxsize']) {
                die($mod_strings['LBL_IMAGE_UPLOAD_FAIL'].$sugar_config['upload_maxsize']);    
            }else {
                $this->product_image=$sugar_config['site_url'].'/'.$sugar_config['upload_dir'].$_FILES['uploadimage']['name'];
		move_uploaded_file($_FILES['uploadimage']['tmp_name'], $sugar_config['upload_dir'].$_FILES['uploadimage']['name']);
            }
	}
        parent::save($check_notify);
        if(isset($_POST['item_id']) && !empty($_POST['item_id'])){
	    $this->saveListItems();
	}
    }   
    
    function saveListItems(){
        
                
		require_once('modules/GEA_PRODUCTS_KIT/GEA_PRODUCTS_KIT.php');
		$productKit = new GEA_PRODUCTS_KIT();
		$product = array(
                                    'id' => $_POST['itemKit_id'],
                                    'item_id' => $_POST['item_id'],
                                    'item_name' => $_POST['item_name'],
                                    'item_deleted' => $_POST['item_deleted']
                                );
		$productKitCount = count($product['item_id']);

                for ($i = 0; $i < $productKitCount; $i++) {
                    $productKit->id = $product['id'][$i];
                    $productKit->product_parent = $this->id;
                    $productKit->product_children = $product["item_id"][$i];
                    $productKit->name = $product["item_name"][$i];
                    $productKit->deleted = $product["item_deleted"][$i];
                    if ($productKit->deleted == 1) {
                        $productKit->mark_deleted($productKit->id);
                    } else {
                        if($productKit->product_parent != '' ){
                            $productKit->save();
                        }
                    }
                }
               
	}

        
    function GetStockValues()
    {

        $db = DBManagerFactory::getInstance();
        $query = "(
                    SELECT DATE(aosp.date_entered) AS date, aos.before_value_string AS stock
                    FROM aos_products aosp 
                    INNER JOIN aos_products_audit aos on (aosp.id = aos.parent_id)
                    WHERE 
                    aos.parent_id = '".$this->id."' AND
                    aos.field_name = 'stock'
                    ORDER BY date_entered DESC
                    LIMIT 1
                    )
                    UNION ALL
                    (
                    SELECT DATE(date_created) AS date, after_value_string AS stock
                    FROM aos_products_audit aos
                    INNER JOIN aos_products aosp ON (aos.parent_id = aosp.id)
                    WHERE 
                    aos.parent_id = '".$this->id."' AND
                    aos.field_name = 'stock'
                    ORDER BY date_created ASC
                    )
                    UNION ALL
                    (
                    SELECT CURDATE() AS date, stock AS stock
                    FROM aos_products
                    WHERE id ='".$this->id."'
                    );";

        $result = $db->query($query, $dieOnError=true);

        while ($row = $db->fetchByAssoc($result))
        {
            $values[] = array($row['date'], (int) $row['stock']);
        }
        return ($values);
    }

    function GetOrderPointValues()
    {

        $db = DBManagerFactory::getInstance();
        $query = "(
                    SELECT DATE(aosp.date_entered) AS date, aos.before_value_string AS order_point
                    FROM aos_products aosp 
                    INNER JOIN aos_products_audit aos on (aosp.id = aos.parent_id)
                    WHERE 
                    aos.parent_id = '".$this->id."' AND
                    aos.field_name = 'order_point'
                    ORDER BY date_entered DESC
                    LIMIT 1
                    )
                    UNION ALL
                    (
                    SELECT DATE(date_created) AS date, after_value_string AS order_point
                    FROM aos_products_audit aos
                    INNER JOIN aos_products aosp ON (aos.parent_id = aosp.id)
                    WHERE 
                    aos.parent_id = '".$this->id."' AND
                    aos.field_name = 'order_point'
                    ORDER BY date_created ASC
                    ) 
                    UNION ALL
                    (
                    SELECT CURDATE() AS date, order_point AS order_point
                    FROM aos_products
                    WHERE id ='".$this->id."'
                    );";

        $result = $db->query($query, $dieOnError=true);
        while ($row = $db->fetchByAssoc($result))
        {
            $values[] = array($row['date'], (int) $row['order_point']);
        }
        return ($values);
    }
	
}
?>
