{*

/*********************************************************************************
 * SugarCRM Community Edition is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004-2013 SugarCRM Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by SugarCRM".
 ********************************************************************************/




*}

{if $strMsjResponse != ""}
    <div class="ui-widget">
	<div class="ui-state-highlight ui-corner-all" style="margin-top: 20px; padding: 0 .7em;">
            <p>
                <br/>
                <span class="ui-icon ui-icon-info" style="float: left; margin-right: .3em;"></span>
                <strong>Informaci&oacute;n!</strong>
                {$strMsjResponse}
                <br/>
            </p>
	</div>
    </div>
{/if}


<script type='text/javascript' src='{sugar_getjspath file='include/javascript/popup_helper.js'}'></script>

<script>
{literal}
	$(document).ready(function(){
	    $("ul.clickMenu").each(function(index, node){
	  		$(node).sugarActionMenu();
	  	});

        $('.selectActionsDisabled').children().each(function(index) {
            $(this).attr('onclick','').unbind('click');
        });
        
        var selectedTopValue = $("#selectCountTop").attr("value");
        if(typeof(selectedTopValue) != "undefined" && selectedTopValue != "0"){
        	sugarListView.prototype.toggleSelected();
        }
	});
{/literal}	
</script>
{assign var="currentModule" value = $pageData.bean.moduleDir}
{assign var="singularModule" value = $moduleListSingular.$currentModule}
{assign var="moduleName" value = $moduleList.$currentModule}
{assign var="hideTable" value=false}

{if count($data) == 0}
	{assign var="hideTable" value=true}
	<div class="list view listViewEmpty">
    {if $displayEmptyDataMesssages}
        {if strlen($query) == 0}
                {capture assign="createLink"}<a href="?module={$pageData.bean.moduleDir}&action=EditView&return_module={$pageData.bean.moduleDir}&return_action=DetailView">{$APP.LBL_CREATE_BUTTON_LABEL}</a>{/capture}
                {capture assign="importLink"}<a href="?module=Import&action=Step1&import_module={$pageData.bean.moduleDir}&return_module={$pageData.bean.moduleDir}&return_action=index">{$APP.LBL_IMPORT}</a>{/capture}
                {capture assign="helpLink"}<a target="_blank" href='?module=Administration&action=SupportPortal&view=documentation&version={$sugar_info.sugar_version}&edition={$sugar_info.sugar_flavor}&lang=&help_module={$currentModule}&help_action=&key='>{$APP.LBL_CLICK_HERE}</a>{/capture}
                <p class="msg">
                    {$APP.MSG_EMPTY_LIST_VIEW_NO_RESULTS|replace:"<item2>":$createLink|replace:"<item3>":$importLink}
                </p>
                <p class="submsg">
                    {$APP.MSG_EMPTY_LIST_VIEW_NO_RESULTS_SUBMSG|replace:"<item1>":$moduleName|replace:"<item4>":$helpLink}
                </p>
        {elseif $query == "-advanced_search"}
            <p class="msg">
                {$APP.MSG_LIST_VIEW_NO_RESULTS_BASIC}
            </p>
        {else}
            <p class="msg">
                {capture assign="quotedQuery"}"{$query}"{/capture}
                {$APP.MSG_LIST_VIEW_NO_RESULTS|replace:"<item1>":$quotedQuery}
            </p>
            <p class = "submsg">
                <a href="?module={$pageData.bean.moduleDir}&action=EditView&return_module={$pageData.bean.moduleDir}&return_action=DetailView">
                    {$APP.MSG_LIST_VIEW_NO_RESULTS_SUBMSG|replace:"<item1>":$quotedQuery|replace:"<item2>":$singularModule}
                </a>

            </p>
        {/if}
    {else}
        <p class="msg">
            {$APP.LBL_NO_DATA}
        </p>
	{/if}
	</div>
{/if}
{$multiSelectData}

{if $hideTable == false}
	<table cellpadding='0' cellspacing='0' width='100%' border='0' class='list view'>
    {assign var="link_select_id" value="selectLinkTop"}
    {assign var="link_action_id" value="actionLinkTop"}
    {assign var="actionsLink" value=$actionsLinkTop}
    {assign var="selectLink" value=$selectLinkTop}
    {assign var="action_menu_location" value="top"}
	{include file='include/ListView/ListViewPagination.tpl'}
	
    <tr height='20'>
            <td width='1%' class="td_alt">&nbsp;</td>

            {if $prerow}

                    <!--<td width='1%' class="td_alt">
                            &nbsp;
                    </td>-->
            {/if}
            {if !empty($quickViewLinks)}
                <!--<td class='td_alt' width='1%' style="padding: 0px;">&nbsp;</td>-->
            {/if}
            {counter start=0 name="colCounter" print=false assign="colCounter"}
            {foreach from=$displayColumns key=colHeader item=params}
                
                {if $colHeader == "ID_TIENDA" || $colHeader == "DO_NOT_CALL"}
                {else}
                        <th scope='col' width='{$params.width}%'>

                            <div style='white-space: normal;'width='100%' align='{$params.align|default:'left'}'>
                                {if $params.sortable|default:true}
                                    {if $params.url_sort}
                                        <a href='{$pageData.urls.orderBy}{$params.orderBy|default:$colHeader|lower}' class='listViewThLinkS1'>
                                    {else}
                                        {if $params.orderBy|default:$colHeader|lower == $pageData.ordering.orderBy}
                                            <a href='javascript:sListView.order_checks("{$pageData.ordering.sortOrder|default:ASCerror}", "{$params.orderBy|default:$colHeader|lower}" , "{$pageData.bean.moduleDir}{"2_"}{$pageData.bean.objectName|upper}{"_ORDER_BY"}")' class='listViewThLinkS1'>
                                        {else}
                                            <a href='javascript:sListView.order_checks("ASC", "{$params.orderBy|default:$colHeader|lower}" , "{$pageData.bean.moduleDir}{"2_"}{$pageData.bean.objectName|upper}{"_ORDER_BY"}")' class='listViewThLinkS1'>
                                        {/if}
                                    {/if}
                                                {sugar_translate label=$params.label module=$pageData.bean.moduleDir}
                                                &nbsp;&nbsp;
                                                {if $params.orderBy|default:$colHeader|lower == $pageData.ordering.orderBy}
                                                    {if $pageData.ordering.sortOrder == 'ASC'}
                                                        {capture assign="imageName"}arrow_down.{$arrowExt}{/capture}
                                                        {capture assign="alt_sort"}{sugar_translate label='LBL_ALT_SORT_DESC'}{/capture}
                                                        {sugar_getimage name=$imageName attr='align="absmiddle" border="0" ' alt="$alt_sort"}
                                                    {else}
                                                        {capture assign="imageName"}arrow_up.{$arrowExt}{/capture}
                                                        {capture assign="alt_sort"}{sugar_translate label='LBL_ALT_SORT_ASC'}{/capture}
                                                        {sugar_getimage name=$imageName attr='align="absmiddle" border="0" ' alt="$alt_sort"}
                                                    {/if}
                                                {else}
                                                    {capture assign="imageName"}arrow.{$arrowExt}{/capture}
                                                    {capture assign="alt_sort"}{sugar_translate label='LBL_ALT_SORT'}{/capture}
                                                    {sugar_getimage name=$imageName attr='align="absmiddle" border="0" ' alt="$alt_sort"}
                                                {/if}
                                            </a>
                                                {else}
                                                    {if !isset($params.noHeader) || $params.noHeader == false} 
                                                        {sugar_translate label=$params.label module=$pageData.bean.moduleDir}
                                                    {/if}
                                                {/if}

                            </div>
                    </th>
                {/if}
                {counter name="colCounter"}
            {/foreach}
            <td class='td_alt' nowrap="nowrap" width='1%'>&nbsp;</td>
        </tr>
			
        {counter start=$pageData.offsets.current print=false assign="offset" name="offset"}	
        {foreach name=rowIteration from=$data key=id item=rowData}
            {counter name="offset" print=false}
            {assign var='scope_row' value=true}
	
                {if $smarty.foreach.rowIteration.iteration is odd}
                    {assign var='_rowColor' value=$rowColor[0]}
                {else}
                    {assign var='_rowColor' value=$rowColor[1]}
                {/if}
                {if $rowData.DO_NOT_CALL == 1}
                    {assign var='backCustom' value='background-color:#F9D1D1 !important;'}
                {else}
                    {assign var='backCustom' value=''}
                {/if}
                <tr id="trRowBody{$offset}" height='20' class='{$_rowColor}S1' style="{$backCustom}">
                    <td width='1%' class="td_alt">&nbsp;{$offset}&nbsp;</td>
                    {if $prerow}
                        <!--<td width='1%' class='nowrap'>
                            {if !$is_admin && is_admin_for_user && $rowData.IS_ADMIN==1}
                               <input type='checkbox' disabled="disabled" class='checkbox' value='{$rowData.ID}'>
                            {else}
                               <!--<input title="{sugar_translate label='LBL_SELECT_THIS_ROW_TITLE'}" onclick='sListView.check_item(this, document.MassUpdate)' type='checkbox' class='checkbox' name='mass[]' value='{$rowData.ID}'>-->
                            {/if}
                        <!--</td>-->
                    {/if}
                    {if !empty($quickViewLinks)}
                        {capture assign=linkModule}{if $params.dynamic_module}{$rowData[$params.dynamic_module]}{else}{$pageData.bean.moduleDir}{/if}{/capture}
                        {capture assign=action}{if $act}{$act}{else}EditView{/if}{/capture}
                        <!--<td width='2%' nowrap>
                            {if $pageData.rowAccess[$id].edit}
                                <a title='{$editLinkString}' id="edit-{$rowData.ID}"
                                    href="index.php?module={$linkModule}&offset={$offset}&stamp={$pageData.stamp}&return_module={$linkModule}&action={$action}&record={$rowData.ID}"
                                >
                                {capture name='tmp1' assign='alt_edit'}{sugar_translate label="LNK_EDIT"}{/capture}
                                {sugar_getimage name="edit_inline.gif" attr='border="0" ' alt="$alt_edit"}</a>
                            {/if}
                        </td>-->
                    {/if}
                    {counter start=0 name="colCounter" print=false assign="colCounter"}
                    {foreach from=$displayColumns key=col item=params}
                        {strip}
                            {if $col == "ID_TIENDA" || $col == "DO_NOT_CALL" }
                            {else}
                                {capture assign=style_c}{/capture}
                                {if $col == "NAME_GESTION" || $col == "ULTIMA_FECHA_CALLCENTER" || 
                                    $col == "PROXIMA_LLAMADA" || $col == "DESCRIPTION"}
                                        {capture assign=style_c}background-color:#CFFCDE{/capture}
                                {/if}
                                <td style="{$style_c}" {if $scope_row} scope='row' {/if} align='{$params.align|default:'left'}' valign="top" class="{if ($params.type == 'teamset')}nowrap{/if}{if preg_match('/PHONE/', $col)} phone{/if}">
                                                    {if $col == 'NAME' || $params.bold}<b>{/if}
                                                    {if $params.link && !$params.customCode}
                                                        {capture assign=linkModule}{if $params.dynamic_module}{$rowData[$params.dynamic_module]}{else}{$params.module|default:$pageData.bean.moduleDir}{/if}{/capture}
                                                        {capture assign=action}{if $act}{$act}{else}DetailView{/if}{/capture}
                                                        {capture assign=record}{$rowData[$params.id]|default:$rowData.ID}{/capture}
                                                        {capture assign=url}index.php?module={$linkModule}&offset={$offset}&stamp={$pageData.stamp}&return_module={$linkModule}&action={$action}&record={$record}{/capture}
                                                        <{$pageData.tag.$id[$params.ACLTag]|default:$pageData.tag.$id.MAIN} href="{sugar_ajax_url url=$url}">

                                                    {/if}

                                                    {if $params.customCode} 
                                                        {sugar_evalcolumn_old var=$params.customCode rowData=$rowData}
                                                    {else}
                                                        {if $col == "CLIENTE_VIP_C" || $col == "NAME_TIENDA" || 
                                                            $col == "ID_TIENDA" || $col == "PHONE_HOME" ||
                                                            $col == "PHONE_WORK" || $col == "NAME_GESTION" || 
                                                            $col == "ULTIMA_FECHA_CALLCENTER" || $col == "PROXIMA_LLAMADA" ||
                                                            $col == "DESCRIPTION" || $col == "BIRTHDATE"
                                                        }
                                                            {if $col == "BIRTHDATE" }
                                                                {if $rowData.BIRTHDATE|substr:5:2 == '01'}Enero{/if}
                                                                {if $rowData.BIRTHDATE|substr:5:2 == '02'}Febrero{/if}
                                                                {if $rowData.BIRTHDATE|substr:5:2 == '03'}Marzo{/if}
                                                                {if $rowData.BIRTHDATE|substr:5:2 == '04'}Abril{/if}
                                                                {if $rowData.BIRTHDATE|substr:5:2 == '05'}Mayo{/if}
                                                                {if $rowData.BIRTHDATE|substr:5:2 == '06'}Junio{/if}
                                                                {if $rowData.BIRTHDATE|substr:5:2 == '07'}Julio{/if}
                                                                {if $rowData.BIRTHDATE|substr:5:2 == '08'}Agosto{/if}
                                                                {if $rowData.BIRTHDATE|substr:5:2 == '09'}Septiembre{/if}
                                                                {if $rowData.BIRTHDATE|substr:5:2 == '10'}Octubre{/if}
                                                                {if $rowData.BIRTHDATE|substr:5:2 == '11'}Noviembre{/if}
                                                                {if $rowData.BIRTHDATE|substr:5:2 == '12'}Diciembre{/if}
                                                                {" "}
                                                                {$rowData.BIRTHDATE|substr:8}
                                                            {/if}
                                                            {if $col == "CLIENTE_VIP_C" }
                                                                {if $rowData.$col == '1'}
                                                                    Si
                                                                {/if}
                                                            {/if}
                                                            {if $col == "NAME_TIENDA" }
                                                                {capture assign=url_t}index.php?module=stu_tiendas&offset={$offset}&stamp={$pageData.stamp}&return_module=stu_tiendas&action={$action}&record={$rowData.ID_TIENDA}{/capture}
                                                                <{$pageData.tag.$id[$params.ACLTag]|default:$pageData.tag.$id.MAIN} href="{sugar_ajax_url url=$url_t}">
                                                                    {$rowData.$col}
                                                                </{$pageData.tag.$id[$params.ACLTag]|default:$pageData.tag.$id.MAIN}>
                                                            {/if}
                                                            {if $col == "PHONE_HOME" || $col == "PHONE_WORK"}
                                                                {if $rowData.DO_NOT_CALL == 0}
                                                                    <a href="javascript:void(0)" 
                                                                       onclick="
                                                                           fnShowGestion(
                                                                                   '{$rowData.ID}','{$rowData.FIRST_NAME}','{$rowData.PHONE_HOME}',
                                                                                   '{$rowData.PHONE_MOBILE}','{$rowData.PHONE_WORK}',
                                                                                   '{$rowData.NAME_TIENDA}','{$rowData.CLIENTE_VIP_C}',
                                                                                   '{$rowData.BIRTHDATE}','{$rowData.ID_TIENDA}',
                                                                                   '{$rowData.EMAIL_PRINCIPAL}','{$offset}','{$rowData.CEDULA_NIT_C}','{$rowData.FRECUENCIACONTACTO_C}','{$rowData.TIPOCONTACTO_C}','{$rowData.TIPOINFORMACION_C}','{$rowData.TIPOINFORMACIONSM_C}'
                                                                            );"
                                                                    >
                                                                        {sugar_field parentFieldArray=$rowData vardef=$params displayType=ListView field=$col}
                                                                        <img src="themes/default/images/icon_AdminMobile.gif" title="Generar Gestion">
                                                                    </a>
                                                                {else}
                                                                    {sugar_field parentFieldArray=$rowData vardef=$params displayType=ListView field=$col}
                                                                    <img src="themes/default/images/decline_inline.gif" title="Contacto que solicito ser excluido de toda comunicacion" />
                                                                {/if}
                                                            {/if}
                                                            {if $col == "NAME_GESTION" || $col == "ULTIMA_FECHA_CALLCENTER" || 
                                                                $col == "PROXIMA_LLAMADA" || $col == "DESCRIPTION"}
                                                                {if $col == "ULTIMA_FECHA_CALLCENTER"}
                                                                    <a href="javascript:void(0)" onclick='fnShowHistorialGestion("{$rowData.ID}");'>{sugar_field parentFieldArray=$rowData vardef=$params displayType=ListView field=$col}</a>
                                                                {else}
                                                                    {sugar_field parentFieldArray=$rowData vardef=$params displayType=ListView field=$col}
                                                                {/if}
                                                                    
                                                            {/if}
                                                        {else}
                                                            {sugar_field parentFieldArray=$rowData vardef=$params displayType=ListView field=$col}
                                                        {/if}


                                                    {/if}
                                                    {if empty($rowData.$col) && empty($params.customCode)}&nbsp;{/if}
                                                    {if $params.link && !$params.customCode}
                                                        </{$pageData.tag.$id[$params.ACLTag]|default:$pageData.tag.$id.MAIN}>
                                                    {/if}
                                {if $col == 'NAME' || $params.bold}</b>{/if}
                                            </td>
                                            {/if}
					{/strip}
	                {assign var='scope_row' value=false}
					{counter name="colCounter"}
				{/foreach}
				<td align='right'>{$pageData.additionalDetails.$id}</td>
		    	</tr>
		{foreachelse}
		<tr height='20' class='{$rowColor[0]}S1'>
		    <td colspan="{$colCount}">
		        <em>{$APP.LBL_NO_DATA}</em>
		    </td>
		</tr> 
		{/foreach}
    {assign var="link_select_id" value="selectLinkBottom"}
    {assign var="link_action_id" value="actionLinkBottom"}
    {assign var="selectLink" value=$selectLinkBottom}
    {assign var="actionsLink" value=$actionsLinkBottom}
    {assign var="action_menu_location" value="bottom"}
    {include file='include/ListView/ListViewPagination.tpl'}
	</table>
{/if}
{if $contextMenus}
<script type="text/javascript">
{$contextMenuScript}
{literal}
function lvg_nav(m,id,act,offset,t){
    if(t.href.search(/#/) < 0){return;}
    else{
        if(act=='pte'){
            act='ProjectTemplatesEditView';
        }
        else if(act=='d'){
            act='DetailView';
        }else if( act =='ReportsWizard'){
            act = 'ReportsWizard';
        }else{
            act='EditView';
        }
    {/literal}
        url = 'index.php?module='+m+'&offset=' + offset + '&stamp={$pageData.stamp}&return_module='+m+'&action='+act+'&record='+id;
        t.href=url;
    {literal}
    }
}{/literal}
{literal}
    function lvg_dtails(id){{/literal}
        return SUGAR.util.getAdditionalDetails( '{$pageData.bean.moduleDir|default:$params.module}',id, 'adspan_'+id);{literal}}{/literal}
</script>
{/if}
    <div id='reportecontactos' title='reportecontactos'>
        <div id="mostrardatos">
            
        </div>
    </div>


    <div id="divOculto" style="display:none;">
        
        <div id="divGestionCallcenter" title="Gestion de callcenter">
            <div id="divPreloadGestionCallcenter" style="color:red;font-family:verdana;"></div>
            <div id="divBodyGestionCallcenter">
                <div id="divPreFormGestionCallcenter">
                    <form id="frmGestionCallcenter" method="post" action="">
                        <input type="hidden" id="hdnoffset" name="hdnoffset"/>
                        <input type="hidden" id="hdnidcontacto" name="hdnidcontacto" />
                        <table style="width:100%;">
                            <tr>
                                <td>
                                    <fieldset >
                                        <legend>Datos Contacto</legend>
                                        <!-- Table que contiene el fieldset de la fila superior-->
                                        <table style="width:100%;">
                                            <tr>
                                                <td> 
                            <table width="100%" border="1" cellspacing="0" cellpadding="0">
  <tr>
    <td width="48%"><!-- Subtabla columna izquierda -->
                                                    <table>
                                                      <tr>
                                                        <td colspan="3"><img src="themes/default/images/_blank.png" width="10" height="10"></td>
                                                      </tr>
                                                       <tr>
                                                           <td width="111" align="right">
                                                                <span><b>Contacto:</b></span></td>
                                                           <td width="6">
                                                                <label id="spnFirstName">&nbsp;</label>
                                                                <input  type="text" id="txtFirstName" name="txtFirstName" style="display:none;"/></td>
                                                           <td width="85"><a style ="float: rigth;"href="javascript:void(0)" onClick="fnEditInlineField();"><img src="themes/default/images/edit_inline.gif" title="Actualizar datos"/></a></td>
                                                       </tr>
                                                       <tr>
                                                         <td colspan="3"><img src="themes/default/images/_blank.png" width="10" height="10"></td>
                                                       </tr>
                                                       <tr>
                                                            <td align="right">
                                                                <span><b>Casa:</b></span></td>
                                                            <td>
                                                                <label id="spnTelCasa">&nbsp;</label>
                                                                <input  type="text" id="txtTelCasa" name="txtTelCasa" style="display:none;"/></td>
                                                            <td><a href="javascript:void(0)" onClick="fnEditInlineField();"><img src="themes/default/images/edit_inline.gif" title="Actualizar datos"/></a></td>
                                                       </tr>
                                                       <tr>
                                                         <td colspan="3"><img src="themes/default/images/_blank.png" width="10" height="10"></td>
                                                       </tr>
                                                       <tr>
                                                           <td align="right">
                                                                <span><b>Whatsapp:</b></span></td>
                                                           <td>
                                                                <label id="spnTelCelu">&nbsp;</label>
                                                                <input  type="text" id="txtTelCelu" name="txtTelCelu" style="display:none;"/></td>
                                                           <td><a href="javascript:void(0)" onClick="fnEditInlineField();"><img src="themes/default/images/edit_inline.gif" title="Actualizar datos"/></a></td>
                                                       </tr>
                                                       <tr>
                                                         <td colspan="3"><img src="themes/default/images/_blank.png" width="10" height="10"></td>
                                                       </tr>
                                                       <tr>
                                                            <td align="right"><b>Tel 2:</b>
                                                         </td>
                                                            <td>
                                                                <label id="spnTelTrabajo">&nbsp;</label>
                                                                <input  type="text" id="txtTelTrabajo" name="txtTelTrabajo" style="display:none;"/></td>
                                                            <td><a href="javascript:void(0)" onClick="fnEditInlineField();"><img src="themes/default/images/edit_inline.gif" title="Actualizar datos"/></a></td>
                                                       </tr>
                                                       <tr>
                                                         <td colspan="3"><img src="themes/default/images/_blank.png" width="10" height="10"></td>
                                                       </tr>
                                                       <tr>
                                                         <td>&nbsp;</td>
                                                         <td>&nbsp;</td>
                                                         <td>&nbsp;</td>
                                                       </tr>  
                                                    </table></td>
    <td>&nbsp;</td>
    <td width="48%" align="left"><!-- Subtabla columna izquierda -->
                                                    <table>
                                                      <tr>
                                                        <td colspan="3"><img src="themes/default/images/_blank.png" width="10" height="10"></td>
                                                      </tr>
                                                        <tr>
                                                            <td align="right"><b>Tienda:</b></td>
                                                            <td>
                                                                <label id="spnTienda">&nbsp;</label>
                                                                <select id="selTienda" name="selTienda" style="display:none;">
                                                                    <option value="">Selecione...</option>
                                                                    {foreach from=$dataListStuTiendas key=colHeader item=params}
                                                                        <option value="{$params.id}">{$params.name}</option>
                                                                    {/foreach}
                                                                </select></td>
                                                            <td><a href="javascript:void(0)" onClick="fnEditInlineField();"><img src="themes/default/images/edit_inline.gif" title="Actualizar datos"/></a></td>
                                                        </tr>
                                                        <tr>
                                                          <td colspan="3"><img src="themes/default/images/_blank.png" width="10" height="10"></td>
                                                        </tr>
                                                        <tr>
                                                            <td align="right"><b>Cedula:</b></td>
                                                            <td>
                                                                <label id="spnCedula">&nbsp;</label>
                                                                <input  type="text" id="txtCedula" name="txtCedula" style="display:none;"/></td>
                                                            <td><a href="javascript:void(0)" onClick="fnEditInlineField();"><img src="themes/default/images/edit_inline.gif" title="Actualizar datos"/></a></td>
                                                        </tr>
                                                        <tr>
                                                          <td colspan="3"><img src="themes/default/images/_blank.png" width="10" height="10"></td>
                                                        </tr>
                                                        <tr>
                                                            <td align="right"><b>VIP:</b></td>
                                                            <td>
                                                                <label id="spnVip">&nbsp;</label>
                                                                <select id="selVip" name="selVip" style="display:none;">
                                                                    <option value="0">No</option>
                                                                    <option value="1">Si</option>
                                                                </select></td>
                                                            <td><a href="javascript:void(0)" onClick="fnEditInlineField();"><img src="themes/default/images/edit_inline.gif" title="Actualizar datos"/></a></td>
                                                        </tr>
                                                        <tr>
                                                          <td colspan="3"><img src="themes/default/images/_blank.png" width="10" height="10"></td>
                                                        </tr>
                                                        <tr>
                                                            <td align="right"><b>Cumplea&ntilde;os:</b></td>
                                                            <td>
                                                                <label id="spnCumples">&nbsp;</label>
                                                                <span id="divCumples" style="display:none;">
                                                                <select id="selMesCumples" name="selMesCumples">
                                                                    <option value="">...</option>
                                                                    <option value="1">Enero</option>
                                                                    <option value="2">Febrero</option>
                                                                    <option value="3">Marzo</option>
                                                                    <option value="4">Abril</option>
                                                                    <option value="5">Mayo</option>
                                                                    <option value="6">Junio</option>
                                                                    <option value="7">Julio</option>
                                                                    <option value="8">Agosto</option>
                                                                    <option value="9">Septiembre</option>
                                                                    <option value="10">Octubre</option>
                                                                    <option value="11">Noviembre</option>
                                                                    <option value="12">Diciembre</option>
                                                                </select>
                                                                <select id="selDiaCumples" name="selDiaCumples">
                                                                    <option value="">...</option>
                                                                    <option value="1">1</option><option value="2">2</option>
                                                                    <option value="3">3</option><option value="4">4</option>
                                                                    <option value="5">5</option><option value="6">6</option>
                                                                    <option value="7">7</option><option value="8">8</option>
                                                                    <option value="9">9</option><option value="10">10</option>
                                                                    <option value="11">11</option><option value="12">12</option>
                                                                    <option value="13">13</option><option value="14">14</option>
                                                                    <option value="15">15</option><option value="16">16</option>
                                                                    <option value="17">17</option><option value="18">18</option>
                                                                    <option value="19">19</option><option value="20">20</option>
                                                                    <option value="21">21</option><option value="22">22</option>
                                                                    <option value="23">23</option><option value="24">24</option>
                                                                    <option value="25">25</option><option value="26">26</option>
                                                                    <option value="27">27</option><option value="28">28</option>
                                                                    <option value="29">29</option><option value="30">30</option>
                                                                    <option value="31">31</option>
                                                                </select>
                                                                </span></td>
                                                            <td><a href="javascript:void(0)" onClick="fnEditInlineField();"><img src="themes/default/images/edit_inline.gif" title="Actualizar datos"/></a></td>
                                                        </tr>
                                                        <tr>
                                                          <td colspan="3"><img src="themes/default/images/_blank.png" width="10" height="10"></td>
                                                        </tr>
                                                        <tr>
                                                            <td align="right"><b>Email:</b></td>
                                                            <td>
                                                                <label id="spnEmailP">&nbsp;</label>
                                                                <input  type="text" id="txtEmailP" name="txtEmailP" style="display:none;"/></td>
                                                            <td><a href="javascript:void(0)" onClick="fnEditInlineField();"><img src="themes/default/images/edit_inline.gif" title="Actualizar datos"/></a></td>
                                                        </tr>
                                                        <tr>
                                                          <td colspan="3"><img src="themes/default/images/_blank.png" width="10" height="10"></td>
                                                        </tr>
                  </table></td>
  </tr>
</table>
                        
                                                
                                                    
                                                </td>    
                                            </tr>
                                        </table>
                                    </fieldset>
                                </td>
                                <td valign="top">
                                  <fieldset >
                                    <legend>Envio Campañas</legend>
                                      <table>
                                          <tr>
                                              <td align="right"><b>Frecuencia</b></td>
                                                <td>
                                                  <label id="spnFrecuenciaContacto">&nbsp;</label>
                                                  <select id="selFrecuenciaContacto" name="selFrecuenciaContacto" style="display:none;">
                                                      <option value=""></option>
                                                      <option value="Semanal">Semanal</option>
                                                      <option value="Quincenal">Quincenal</option>
                                                      <option value="Mensual">Mensual</option>
                                                  </select></td>
                                                <td><a href="javascript:void(0)" onClick="fnEditInlineField();"><img src="themes/default/images/edit_inline.gif" title="Actualizar datos"/></a></td>
                                          </tr>
                                          <tr>
                                            <td colspan="3"><img src="themes/default/images/_blank.png" width="10" height="10"></td>
                                          </tr>
                                          <tr>
                                              <td align="right"><b>Tipo de contacto</b></td>
                                                <td>
                                                  <label id="spnTipoContacto">&nbsp;</label>
                                                  <select id="selTipoContacto" name="selTipoContacto" style="display:none;">
                                                      <option value=""></option>
                                                      <option value="Mail">Mail</option>
                                                      <option value="Redes_Sociales">Redes Sociales</option>
                                                      <option value="Telefono">Teléfono</option>
                                                      <option value="Whatsapp">Whatsapp</option>
                                                      <option value="Todas">Todas</option>
                                                  </select>
                                                  <!--<span><b>Seleccione el tipo de Informaci&oacute;n</b></span>
                                                    <label id="spnTipoInformacionNormal">&nbsp;</label>
                                                 
                                                    <select id="selTipoInformacionNormal"  name="selTipoInformacionNormal"   style="display:none;">
                                                        <option value=""></option>
                                                        <option value="Beneficios">Beneficios</option>
                                                        <option value="Colecciones">Colecciones</option>
                                                        <option value="Promociones">Promociones</option>
                                                        <option value="Todas">Todas</option>
                                                    </select>
                                                    <a href="javascript:void(0)" onclick="fnEditInlineField();">
                                                        <img src="themes/default/images/edit_inline.gif" title="Actualizar datos"/>
                                                    </a></br>-->    
                                              </td>
                                                <td><a href="javascript:void(0)" onClick="fnEditInlineField();"><img src="themes/default/images/edit_inline.gif" title="Actualizar datos"/></a></td>
                                          </tr>
                                          <tr>
                                            <td colspan="3"><img src="themes/default/images/_blank.png" width="10" height="10"></td>
                                          </tr>
                                          <tr>
                                              <td align="right"><b>Tipo de Info.</b></td>
                                                <td>
                                                  <label id="spnTipoInformacionMultiple">&nbsp;</label>
                                                  <!--
                                                    se cambia el select selTipoInformacion  de un select normal a un select 
                                                    multiple 
                                                    -->

                                                  <select id="selTipoInformacionMultiple"  name="selTipoInformacionMultiple[]"  multiple="multiple" style="display:none;">
                                                      <option value=""></option>
                                                      <option value="Beneficios">Beneficios</option>
                                                      <option value="Colecciones">Colecciones</option>
                                                      <option value="Promociones">Promociones</option>
                                                      <option value="Todas">Todas</option>
                                                  </select></td>
                                                <td><a href="javascript:void(0)" onClick="fnEditInlineField();"><img src="themes/default/images/edit_inline.gif" title="Actualizar datos"/></a></td>
                                          </tr>
                                      </table>
                                        
                                        
                                    </fieldset>    
                                </td>
                            </tr>
                            </table>
                            
                            <!-- Se separaron la dos columnas de informacion con los datos del contacto en la parte superior  -->

                            <table>
                            <tr>
                                <th width="10%" valign="top">
                                    <fieldset>
                                        <legend>Evento</legend>
                                        <div>
                                            <table style="width:100%;">
                                                <tr>
                                                    <td>
                                                        <span>Opciones:</span>
                                                    </td>
                                                    <td>
                                                        <select id="selOpciones" name="selOpciones">
                                                            <option value="">Seleccione...</option>
                                                            {foreach from=$dataListOpcRespuestas key=colHeader item=params}
                                                                {if $params.id == '41dcbc2e-8af7-6a7e-7eed-55eeebb32f18'}
                                                                    <option style='background-color:#F9DDDD;' value="{$params.id}">{$params.name}</option>
                                                                {else}
                                                                    <option value="{$params.id}">{$params.name}</option>
                                                                {/if}
                                                            {/foreach}
                                                        </select>
                                                    </td>
                                                </tr>
                                                <tr id="trProximaLlamada" style="display:none;">
                                                    <td>Proxima llamada</td>
                                                    <td>
                                                        <input id="txtFechaProximaLlamada" name="txtFechaProximaLlamada" type="text" size="15" readonly="readonly" />
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <span>Descripci&oacute;n:</span>
                                                    </td>
                                                    <td>
                                                        <textarea id="tarDescripcion" name="tarDescripcion"></textarea>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <span>Se hablo con:</span>
                                                    </td>
                                                    <td>
                                                        <input type="text" id="txtSeHabloCon" name="txtSeHabloCon"/>
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                        <div>
                                            <input type="button" id="bttnSubmit" value="Guardar Gestion"/>
                                        </div>
                                    </fieldset>
                                </th>
                                <th width="90%" valign="top">
                                    <fieldset>
                                        <legend>Historial Compras</legend>
                                        <div id="divTabsCat">
                                            <ul>
                                                <li><a href="#tabC1">Compras</a></li>
                                                <li><a href="#tabC2">Callcenter</a></li>
                                            </ul>
                                            <div id="tabC1">
                                                <div id="divTabsCompras">
                                                    <ul id="ulDivTabsCompras">
                                                        <img src="themes/default/images/ui-anim_basic_16x16.gif"/>
                                                        <br/>
                                                        Cargando informaci&oacute;n...
                                                    </ul>
                                                </div>
                                            </div>
                                            <div id="tabC2">
                                                <img src="themes/default/images/ui-anim_basic_16x16.gif"/>
                                                <br/>
                                                Cargando informaci&oacute;n...
                                            </div>
                                        </div>
                                    </fieldset>
                                </th>
                            </tr>
                        </table>
                    </form>
                </div>
                <div>
                    
                </div>
            </div>
        </div>
        
        <select id="selStuTiendas_hidden">
            <option value="">TODAS</option>
            {foreach from=$dataListStuTiendas key=colHeader item=params}
                <option value="{$params.id}">{$params.name}</option>
            {/foreach}
        </select>
        



        
        <div id='divHistorialGestion' title='Historial gestion'>
            <div id="divPreloadHistorialGestion" style="color:red;font-family:verdana;"></div>
            <div id="divBodyHistorialGestion"></div>
        </div>

        
        
        <div id='divHistorialReporteCallcenter' title='Reporte Callcenter'>
            <ul>
                <li><a href='#divReport1'>Llamadas/Tienda</a></li>
                <li><a href='#divReport2'>Llamadas/Operador</a></li>
                <li><a href='#divReport3'>Clientes</a></li>
                <!--
                    agregado por:darwin rosero 
                    se agrege este link para que llame a la nueva pesteña
                    
                -->
                <!--<li><a href='#divReport4'>Campañas</a></li>
                <li><a href='#divReport5'>Reportes</a></li>-->
            </ul>
            <div id='divReport1'>
                <div id="divPreloadReport1" style="color:red;font-family:verdana;"></div>
                <div>
                    <input type='text' id='txtFechaDesdeReport1' size='10' readonly="readonly" value='{$smarty.now|date_format:"%Y-%m-%d"}'/>
                    <input type='text' id='txtFechaHastaReport1' size='10' readonly="readonly" value='{$smarty.now|date_format:"%Y-%m-%d"}'/>
                    <input type='button' id='bttnReport1' value='Buscar' />
                    <div id='divExport_1' style='float:right;'>
                        <a href='javascript:void(0)' onclick='fnExportDoc("pdf",1)'><img src="themes/default/images/pdf_image_inline.gif" title='Exportar a pdf'></a>
                        <a href='javascript:void(0)' onclick='fnExportDoc("xlsx",1)'><img src="themes/default/images/xls_image_inline.gif" title='Exportar a xlsx'></a>
                    </div>
                </div>
                <div id="divBodyReport1">
                </div>
            </div>
            <div id='divReport2'>
                <div id="divPreloadReport2" style="color:red;font-family:verdana;"></div>
                <div>
                    <input type='text' id='txtFechaDesdeReport2' size='10' readonly="readonly" value='{$smarty.now|date_format:"%Y-%m-%d"}'/>
                    <input type='text' id='txtFechaHastaReport2' size='10' readonly="readonly" value='{$smarty.now|date_format:"%Y-%m-%d"}'/>
                    <input type='button' id='bttnReport2' value='Buscar' />
                    <div id='divExport_2' style='float:right;'>
                        <a href='javascript:void(0)' onclick='fnExportDoc("pdf",2)'><img src="themes/default/images/pdf_image_inline.gif" title='Exportar a pdf'></a>
                        <a href='javascript:void(0)' onclick='fnExportDoc("xlsx",2)'><img src="themes/default/images/xls_image_inline.gif" title='Exportar a xlsx'></a>
                    </div>
                </div>
                <div id="divBodyReport2">
                </div>
            </div>
            <div id='divReport3'>
                <div id="divPreloadReport3" style="color:red;font-family:verdana;"></div>
                <div>
                    <input type='text' id='txtFechaDesdeReport3' size='10' readonly="readonly" value='{$smarty.now|date_format:"%Y-%m-%d"}'/>
                    <input type='text' id='txtFechaHastaReport3' size='10' readonly="readonly" value='{$smarty.now|date_format:"%Y-%m-%d"}'/>
                    <input type='button' id='bttnReport3' value='Buscar' />
                    <div id='divExport_3' style='float:right;'>
                        <a href='javascript:void(0)' onclick='fnExportDoc("pdf",3)'><img src="themes/default/images/pdf_image_inline.gif" title='Exportar a pdf'></a>
                        <a href='javascript:void(0)' onclick='fnExportDoc("xlsx",3)'><img src="themes/default/images/xls_image_inline.gif" title='Exportar a xlsx'></a>
                    </div>
                </div>
                <div id="divBodyReport3">
                </div>
            </div>

            <!-- agregado por:darwin rosero se agrega este div para la nueva pestaña  -->
 <!-- apago     <div id='divReport4'>
            
                <div id="divPreloadReport4" style="color:red;font-family:verdana;"></div>
                <div>
                    <input type='text' id='txtFechaDesdeReport4' size='10' readonly="readonly" value='{$smarty.now|date_format:"%Y-%m-%d"}'/>
                    <input type='text' id='txtFechaHastaReport4' size='10' readonly="readonly" value='{$smarty.now|date_format:"%Y-%m-%d"}'/>
                    

                    

                    tipo:

                    <select id="selTipoContacto1" name="selTipoContacto1" >
                                        <option value=""></option>
                                        <option value="Mail">Mail</option>
                                        <option value="Redes_Sociales">Redes Sociales</option>
                                        <option value="Telefono">Teléfono</option>
                                        <option value="Whatsapp">Whatsapp</option>
                                        <option value="Todas">Todas</option>
                   </select>

                    periodo:
                    <select id="selFrecuencia" name="selFrecuencia" >
                                        <option value=""></option>
                                        <option value="Semanal">Semanal</option>
                                        <option value="Quincenal">Quincenal</option>
                                        <option value="Mensual">Mensual</option>
                    </select>


                    informacion:
                    <select id="selTipoInformacion"  name="selTipoInformacion">
                                        <option value=""></option>
                                        <option value="Beneficios">Beneficios</option>
                                        <option value="Colecciones">Colecciones</option>
                                        <option value="Promociones">Promociones</option>
                                        <option value="Todas">Todas</option>
                    </select>

                

                    <input type='button' id='bttnReport4' value='Buscar' />
                    <div id='divExport_4' style='float:right;'>
                        <a href='javascript:void(0)' onclick='fnExportDoc("pdf",4)'><img src="themes/default/images/pdf_image_inline.gif" title='Exportar a pdf'></a>
                        <a href='javascript:void(0)' onclick='fnExportDoc("xlsx",4)'><img src="themes/default/images/xls_image_inline.gif" title='Exportar a xlsx'></a>
                    </div>
                </div>
                <div id="divBodyReport4">
                </div>
            </div>  termino apagado reporte 4    -->
            <!--                agregado por:darwin rosero 
              se agrega este div para la nueva pestaña  -->
<!-- apago rep5             <div id='divReport5'>
            
                <div id="divPreloadReport5" style="color:red;font-family:verdana;"></div>
                    
                    <!--{include file='modules/cont_centro_llamadas/tpl/mostrarContactos.tpl'}
                    -->
                <div id="divBodyReport5">
                </div>
            </div>

        </div>
    </div> termino apagado rep5 -->
    
<script type='text/javascript' src='{sugar_getjspath file='include/javascript/jquery/grid/js/jquery.ui.datepicker.js'}'></script>
<script type='text/javascript' src='{sugar_getjspath file='include/javascript/jquery/grid/js/jquery.ui.slider.js'}'></script>    
<script type='text/javascript' src='{sugar_getjspath file='include/javascript/jquery/jquery-ui-timepicker-addon.js'}'></script>
<script type='text/javascript' src='{sugar_getjspath file='include/javascript/jquery/i18n/jquery-ui-timepicker-es.js'}'></script>
<link type="text/css" href='{sugar_getjspath file='include/javascript/jquery/jquery-ui-timepicker-addon.css'}' rel="stylesheet" />
<script>
    {literal}
    $(document).ready(function(){
        $('#divHistorialReporteCallcenter').tabs();
        var myParam = location.search.split('offset=')[1];
        
        if(myParam!=undefined){
            $('#trRowBody'+myParam).addClass('class_bck');
            $('#trRowBody'+myParam).prop('style','background-color:#FBFBC0');

            var target = this.hash;
            var $target = $('#trRowBody'+myParam);
            $('html, body').stop().animate({
                'scrollTop': $target.offset().top
            }, 900, 'swing', function () {
                //window.location.hash = target;
            });
        }
        
        $("#txtFechaDesdeReport1").datepicker({
            buttonImage: "themes/default/images/Calendar.gif",
            buttonImageOnly: true,
            showOn: 'button',
            dateFormat: 'yy-mm-dd',
            changeYear: true,
            changeMonth: true,
            maxDate: '0D',
            onClose: function (selectedDate) {
                $("#txtFechaHastaReport1").datepicker("option", "minDate", selectedDate);
            }
        });
        
        
        $("#txtFechaHastaReport1").datepicker({
            buttonImage: "themes/default/images/Calendar.gif",
            buttonImageOnly: true,
            showOn: 'button',
            dateFormat: 'yy-mm-dd',
            changeYear: true,
            changeMonth: true,
            maxDate: '0D',
            onClose: function (selectedDate) {
                $("#txtFechaDesdeReport1").datepicker("option", "maxDate", selectedDate);
            }
        });
        $("#txtFechaDesdeReport2").datepicker({
            buttonImage: "themes/default/images/Calendar.gif",
            buttonImageOnly: true,
            showOn: 'button',
            dateFormat: 'yy-mm-dd',
            changeYear: true,
            changeMonth: true,
            maxDate: '0D',
            onClose: function (selectedDate) {
                $("#txtFechaHastaReport2").datepicker("option", "minDate", selectedDate);
            }
        });

        $("#txtFechaHastaReport2").datepicker({
            buttonImage: "themes/default/images/Calendar.gif",
            buttonImageOnly: true,
            showOn: 'button',
            dateFormat: 'yy-mm-dd',
            changeYear: true,
            changeMonth: true,
            maxDate: '0D',
            onClose: function (selectedDate) {
                $("#txtFechaDesdeReport2").datepicker("option", "maxDate", selectedDate);
            }
        });
        $("#txtFechaDesdeReport3").datepicker({
            buttonImage: "themes/default/images/Calendar.gif",
            buttonImageOnly: true,
            showOn: 'button',
            dateFormat: 'yy-mm-dd',
            changeYear: true,
            changeMonth: true,
            maxDate: '0D',
            onClose: function (selectedDate) {
                $("#txtFechaHastaReport3").datepicker("option", "minDate", selectedDate);
            }
        });

        $("#txtFechaHastaReport3").datepicker({
            buttonImage: "themes/default/images/Calendar.gif",
            buttonImageOnly: true,
            showOn: 'button',
            dateFormat: 'yy-mm-dd',
            changeYear: true,
            changeMonth: true,
            maxDate: '0D',
            onClose: function (selectedDate) {
                $("#txtFechaDesdeReport3").datepicker("option", "maxDate", selectedDate);
            }
        });
        
       $("#txtFechaDesdeReport4").datepicker({
            buttonImage: "themes/default/images/Calendar.gif",
            buttonImageOnly: true,
            showOn: 'button',
            dateFormat: 'yy-mm-dd',
            changeYear: true,
            changeMonth: true,
            maxDate: '0D',
            onClose: function (selectedDate) {
                $("#txtFechaHastaReport4").datepicker("option", "minDate", selectedDate);
            }
        });

        $("#txtFechaHastaReport4").datepicker({
            buttonImage: "themes/default/images/Calendar.gif",
            buttonImageOnly: true,
            showOn: 'button',
            dateFormat: 'yy-mm-dd',
            changeYear: true,
            changeMonth: true,
            maxDate: '0D',
            onClose: function (selectedDate) {
                $("#txtFechaDesdeReport4").datepicker("option", "maxDate", selectedDate);
            }
        });


        
        $("#divGestionCallcenter").dialog({
            autoOpen: false,
            modal: true,
            draggable: true,
            resizable:true,
            width:'900',
            buttons:{
                "Cerrar":function(){
                    $(this).dialog('close');
                    // set background row
                    $('.class_bck').each(function(){
                        $(this).removeClass('class_bck')
                        $(this).prop('style','')
                    });
                }
            },
            close:function(){
                // set background row
                $('.class_bck').each(function(){
                    $(this).removeClass('class_bck')
                    $(this).prop('style','')
                });
            },
            position: 'top'
        });
        $("#divHistorialGestion").dialog({
            autoOpen: false,
            modal: true,
            draggable: true,
            resizable:true,
            width:'600',
            buttons:{
                "Cerrar":function(){
                    $(this).dialog('close');
                }
            },
            position: 'top'
        });
        $("#divHistorialReporteCallcenter").dialog({
            autoOpen: false,
            modal: true,
            draggable: true,
            resizable:true,
            width:'1200',
            buttons:{
                "Cerrar":function(){
                    $(this).dialog('close');
                }
            },
            position: 'top'
        });

        $("#reportecontactos").dialog({
            autoOpen: false,
            modal: true,
            draggable: true,
            resizable:true,
            width:'900',
            buttons:{
                "Cerrar":function(){
                    $(this).dialog('close');
                }
            },
            position: 'top'
        });


        //set form
        $('#divPreFormGestionCallcenter').html('<form method="post" id="frmGestionCallcenter" action="">'+$('#divPreFormGestionCallcenter').html()+'</form>');
        
        $('#divTabsCat').tabs();
        $('#divTabsCompras').tabs();
        
        //
        $('#bttnSubmit').click(function(){
            fnSaveGestion();
        });
        
        $('#selOpciones').change(function(){
            fnVerificaOpc($(this).val());
        });
        
        /**datepicker**/
        $.timepicker.regional['es'];
        $('#txtFechaProximaLlamada').datetimepicker({
            changeMonth: true,
            numberOfMonths: 1,
            showOn: 'button',
            buttonImage: 'themes/default/images/Calendar.gif',
            buttonImageOnly: true,
            changeYear: true,
            minDate: '0D',
            dateFormat: 'yy-mm-dd',
            timeFormat:  "hh:mm tt",
            controlType: 'select',
            
        }).attr('readonly',true);
        $('.ui-datepicker-trigger').click(function(){
            $('.ui-datepicker-current').css('display','none');
        });
        
        $('#advanced_search_link').remove();
        
        
        
        // set contacts
        $('#cont__centro_llamadas_contactscontacts_ida_basic').prop('name','cont__centro_llamadas_contactscontacts_ida_basic');
        
        // set filtros custom
        $('#estado_gestion_basic').prop('name','estado_gestion_basic');
        $('#estado_gestion_basic').html(
                    '<option value="" selected="selected">TODOS</option>'+
                    '<option value="1">Sin gestion</option>'+
                    '<option value="2">Gestionados</option>'+
                    '<option value="3">Proxima llamada</option>'+
                    '<option value="4">No reciben publicidad</option>'+
                    '<option value="5">Encuesta Realizada</option>'+
                    '<option value="6">Promocion Entregada</option>'+
                    '<option value="7">Venta virtual Realizada</option>'
                );
        $('#estado_gestion_basic').html($('#selOpciones').html()+
                '<option value="1">Sin gestion</option>'+
                '<option value="2">Gestionados</option>'+
                '<option value="4">No reciben publicidad</option>'
        );
        $('#estado_gestion_basic').change(function(){
            fnGestionEstado($(this).val());
        });
        // hidden label prox llamada
        $('#proxima_llamada_basic').parent().prev().children().prop('style','display:none;');
        $('#proxima_llamada_basic').parent().prev().children().html('Prox. Llamada<a href="javascript:void(0)" onclick="fnCleanProxLl();"><img src="themes/default/images/Dashboard.gif" title="Limpiar campos"></a>');
        fnCambiaHtmlProxLlamada($('#proxima_llamada_basic').parent());
        $('#txtFechaDesdeProxLlamada').datetimepicker({
            changeMonth: true,
            numberOfMonths: 1,
            showOn: 'button',
            buttonImage: 'themes/default/images/Calendar.gif',
            buttonImageOnly: true,
            changeYear: true,
            minDate: '0D',
            dateFormat: 'yy-mm-dd',
            timeFormat:  "hh:mm tt",
            controlType: 'select',
            onClose: function(dateText, inst) {
                if ($('#txtFechaHastaProxLlamada').val() != '') {
                    var testStartDate = $('#txtFechaDesdeProxLlamada').datetimepicker('getDate');
                    var testEndDate = $('#txtFechaHastaProxLlamada').datetimepicker('getDate');
                    if (testStartDate > testEndDate)
                        $('#txtFechaHastaProxLlamada').datetimepicker('setDate', testStartDate);
                }
                else {
                    $('#txtFechaHastaProxLlamada').val(dateText);
                }
            },
            onSelect: function (selectedDateTime){
                $('#txtFechaHastaProxLlamada').datetimepicker('option', 'minDate', $('#txtFechaDesdeProxLlamada').datetimepicker('getDate') );
            }
        }).attr('readonly',true);
        $('#txtFechaHastaProxLlamada').datetimepicker({
            changeMonth: true,
            numberOfMonths: 1,
            showOn: 'button',
            buttonImage: 'themes/default/images/Calendar.gif',
            buttonImageOnly: true,
            changeYear: true,
            minDate: '0D',
            dateFormat: 'yy-mm-dd',
            timeFormat:  "hh:mm tt",
            controlType: 'select',
            onClose: function(dateText, inst) {
                if ($('#txtFechaDesdeProxLlamada').val() != '') {
                    var testStartDate = $('#txtFechaDesdeProxLlamada').datetimepicker('getDate');
                    var testEndDate = $('#txtFechaHastaProxLlamada').datetimepicker('getDate');
                    if (testStartDate > testEndDate)
                        $('#txtFechaDesdeProxLlamada').datetimepicker('setDate', testEndDate);
                }
                else {
                    $('#txtFechaDesdeProxLlamada').val(dateText);
                }
            },
            onSelect: function (selectedDateTime){
                $('#txtFechaDesdeProxLlamada').datetimepicker('option', 'maxDate', $('#txtFechaHastaProxLlamada').datetimepicker('getDate') );
            }
        }).attr('readonly',true);
        
        // set trango fecha creacion
        $('#date_entered_basic').parent().prev().children().html('Fecha creacion<a href="javascript:void(0)" onclick="fnCleanCreacion();"><img src="themes/default/images/Dashboard.gif" title="Limpiar campos"></a>');
        fnCambiaHtmlFechaCreacion($('#date_entered_basic').parent());
        $('#txtFechaDesdeCreacion').datetimepicker({
            changeMonth: true,
            numberOfMonths: 1,
            showOn: 'button',
            buttonImage: 'themes/default/images/Calendar.gif',
            buttonImageOnly: true,
            changeYear: true,
            maxDate: '0D',
            dateFormat: 'yy-mm-dd',
            timeFormat:  "hh:mm tt",
            controlType: 'select',
            onClose: function(dateText, inst) {
                if ($('#txtFechaHastaCreacion').val() != '') {
                    var testStartDate = $('#txtFechaDesdeCreacion').datetimepicker('getDate');
                    var testEndDate = $('#txtFechaHastaCreacion').datetimepicker('getDate');
                    if (testStartDate > testEndDate)
                        $('#txtFechaHastaCreacion').datetimepicker('setDate', testStartDate);
                }
                else {
                    $('#txtFechaHastaCreacion').val(dateText);
                }
            },
            onSelect: function (selectedDateTime){
                $('#txtFechaHastaCreacion').datetimepicker('option', 'minDate', $('#txtFechaDesdeCreacion').datetimepicker('getDate') );
            }
        }).attr('readonly',true);
        $('#txtFechaHastaCreacion').datetimepicker({
            changeMonth: true,
            numberOfMonths: 1,
            showOn: 'button',
            buttonImage: 'themes/default/images/Calendar.gif',
            buttonImageOnly: true,
            changeYear: true,
            maxDate: '0D',
            dateFormat: 'yy-mm-dd',
            timeFormat:  "hh:mm tt",
            controlType: 'select',
            onClose: function(dateText, inst) {
                if ($('#txtFechaDesdeCreacion').val() != '') {
                    var testStartDate = $('#txtFechaDesdeCreacion').datetimepicker('getDate');
                    var testEndDate = $('#txtFechaHastaCreacion').datetimepicker('getDate');
                    if (testStartDate > testEndDate)
                        $('#txtFechaDesdeCreacion').datetimepicker('setDate', testEndDate);
                }
                else {
                    $('#txtFechaDesdeCreacion').val(dateText);
                }
            },
            onSelect: function (selectedDateTime){
                $('#txtFechaDesdeCreacion').datetimepicker('option', 'maxDate', $('#txtFechaHastaCreacion').datetimepicker('getDate') );
            }
        }).attr('readonly',true);
        
        // set tiendas
        $('#stu_tiendas_name_basic').prop('name','stu_tiendas_name_basic');
        $('#stu_tiendas_name_basic').html($('#selStuTiendas_hidden').html());
        // set vip
        $('#cliente_vip_c_basic').prop('name','cliente_vip_c_basic');
        $('#cliente_vip_c_basic').html(
            '<option value="" selected="selected">TODOS</option>'+
            '<option value="1">Si</option>'+
            '<option value="0">No</option>'
        );
        // set fecha cumples
        $('#fecha_cumples_basic').prop('name','fecha_cumples_basic');
        $('#fecha_cumples_basic').parent().prev().children().html(
                'Cumplea&ntilde;os<br/>'+
                '&nbsp;Mes: <input type="radio" id="radMes" name="radCumples" checked="checked"/>'+
                '&nbsp;Rango: <input type="radio" id="radRango" name="radCumples"/>'
        );
        $('#radMes,#radRango').click(function(){
            fnCambFechaFiltro();
        });
        $('#fecha_cumples_basic').html(
            '<option value="">TODOS</option>'+
            '<option value="1">Enero</option>'+
            '<option value="2">Febrero</option>'+
            '<option value="3">Marzo</option>'+
            '<option value="4">Abril</option>'+
            '<option value="5">Mayo</option>'+
            '<option value="6">Junio</option>'+
            '<option value="7">Julio</option>'+
            '<option value="8">Agosto</option>'+
            '<option value="9">Septiembre</option>'+
            '<option value="10">Octubre</option>'+
            '<option value="11">Noviembre</option>'+
            '<option value="12">Diciembre</option>'
        );
        // set rango
        $('#fecha_cumples_basic').after(
            '<div id="divFechaRangoCumples" style="display:none;">'+
            '   De: '+
            '<select id="selRangoMesCumplesDe" name="selRangoMesCumplesDe" style="width:auto !important;">'+
            '<option value="">...</option>'+
            '<option value="1">Enero</option>'+
            '<option value="2">Febrero</option>'+
            '<option value="3">Marzo</option>'+
            '<option value="4">Abril</option>'+
            '<option value="5">Mayo</option>'+
            '<option value="6">Junio</option>'+
            '<option value="7">Julio</option>'+
            '<option value="8">Agosto</option>'+
            '<option value="9">Septiembre</option>'+
            '<option value="10">Octubre</option>'+
            '<option value="11">Noviembre</option>'+
            '<option value="12">Diciembre</option>'+
            '</select>'+
            '<select id="selRangoDiaCumplesDe" name="selRangoDiaCumplesDe" style="width:auto !important;">'+
            '<option value="">...</option>'+
            '<option value="1">1</option><option value="2">2</option>'+
            '<option value="3">3</option><option value="4">4</option>'+
            '<option value="5">5</option><option value="6">6</option>'+
            '<option value="7">7</option><option value="8">8</option>'+
            '<option value="9">9</option><option value="10">10</option>'+
            '<option value="11">11</option><option value="12">12</option>'+
            '<option value="13">13</option><option value="14">14</option>'+
            '<option value="15">15</option><option value="16">16</option>'+
            '<option value="17">17</option><option value="18">18</option>'+
            '<option value="19">19</option><option value="20">20</option>'+
            '<option value="21">21</option><option value="22">22</option>'+
            '<option value="23">23</option><option value="24">24</option>'+
            '<option value="25">25</option><option value="26">26</option>'+
            '<option value="27">27</option><option value="28">28</option>'+
            '<option value="29">29</option><option value="30">30</option>'+
            '<option value="31">31</option>'+
            '</select>'+
            '   <br/>Hasta: '+
            '<select id="selRangoMesCumplesHasta" name="selRangoMesCumplesHasta" style="width:auto !important;">'+
            '<option value="">...</option>'+
            '<option value="1">Enero</option>'+
            '<option value="2">Febrero</option>'+
            '<option value="3">Marzo</option>'+
            '<option value="4">Abril</option>'+
            '<option value="5">Mayo</option>'+
            '<option value="6">Junio</option>'+
            '<option value="7">Julio</option>'+
            '<option value="8">Agosto</option>'+
            '<option value="9">Septiembre</option>'+
            '<option value="10">Octubre</option>'+
            '<option value="11">Noviembre</option>'+
            '<option value="12">Diciembre</option>'+
            '</select>'+
            '<select id="selRangoDiaCumplesHasta" name="selRangoDiaCumplesHasta" style="width:auto !important;">'+
            '<option value="">...</option>'+
            '<option value="1">1</option><option value="2">2</option>'+
            '<option value="3">3</option><option value="4">4</option>'+
            '<option value="5">5</option><option value="6">6</option>'+
            '<option value="7">7</option><option value="8">8</option>'+
            '<option value="9">9</option><option value="10">10</option>'+
            '<option value="11">11</option><option value="12">12</option>'+
            '<option value="13">13</option><option value="14">14</option>'+
            '<option value="15">15</option><option value="16">16</option>'+
            '<option value="17">17</option><option value="18">18</option>'+
            '<option value="19">19</option><option value="20">20</option>'+
            '<option value="21">21</option><option value="22">22</option>'+
            '<option value="23">23</option><option value="24">24</option>'+
            '<option value="25">25</option><option value="26">26</option>'+
            '<option value="27">27</option><option value="28">28</option>'+
            '<option value="29">29</option><option value="30">30</option>'+
            '<option value="31">31</option>'+
            '</select>'+
            '</div>'
        );
        
        // set bttn reportes
        $('#selectLinkTop').after("<a href='repetidos.php' target='_blank' ;'><img src='themes/default/images/infoerrada.png' width='20' height='20' title='Reportes'/></a>");

        $('#selectLinkTop').after("<a href='javascript:void(0)' onclick='fnShowReportes();'><img src='themes/default/images/ActivitiesReports.gif' title='Reportes'/></a>");


       
        
        $('#delete_listview_top').remove();
        $('#select_actions_disabled_top').remove();
        $('#actionLinkTop').remove();
        $('#delete_listview_bottom').remove();
        $('#select_actions_disabled_bottom').remove();
        $('#actionLinkBottom').remove();
        
        $('#massall_top').remove();
        $('#massall_bottom').remove();
        $('#selectLinkTop').remove();
        $('#selectLinkBottom').remove();
        
        // veriicamos
        if('{/literal}{$request_custom.selRangoMesCumplesDe}{literal}' != ""){
            $('#radRango').prop('checked',true);
        }else{
            $('#radMes').prop('checked,true');
        }
        fnCambFechaFiltro();
        // set request
        $('#estado_gestion_basic').val('{/literal}{$request_custom.estado_gestion_basic}{literal}');
        fnGestionEstado('{/literal}{$request_custom.estado_gestion_basic}{literal}');
        $('#txtFechaDesdeProxLlamada').val('{/literal}{$request_custom.txtFechaDesdeProxLlamada}{literal}');
        $('#txtFechaHastaProxLlamada').val('{/literal}{$request_custom.txtFechaHastaProxLlamada}{literal}');
        $('#txtFechaDesdeCreacion').val('{/literal}{$request_custom.txtFechaDesdeCreacion}{literal}');
        $('#txtFechaHastaCreacion').val('{/literal}{$request_custom.txtFechaHastaCreacion}{literal}');
        $('#stu_tiendas_name_basic').val('{/literal}{$request_custom.stu_tiendas_name_basic}{literal}');
        $('#cliente_vip_c_basic').val('{/literal}{$request_custom.cliente_vip_c_basic}{literal}');
        $('#cedula_nit_c_basic').val('{/literal}{$request_custom.cedula_nit_c_basic}{literal}');
        $('#email_address_basic').val('{/literal}{$request_custom.email_address_basic}{literal}');
        $('#fecha_cumples_basic').val('{/literal}{$request_custom.fecha_cumples_basic}{literal}');
        $('#selRangoMesCumplesDe').val('{/literal}{$request_custom.selRangoMesCumplesDe}{literal}');
        $('#selRangoDiaCumplesDe').val('{/literal}{$request_custom.selRangoDiaCumplesDe}{literal}');
        $('#selRangoMesCumplesHasta').val('{/literal}{$request_custom.selRangoMesCumplesHasta}{literal}');
        $('#selRangoDiaCumplesHasta').val('{/literal}{$request_custom.selRangoDiaCumplesHasta}{literal}');
        $('#search_form').find('input').each(function(){
            if($(this).prop('name') == 'action'){
               $(this).val('index'); 
            }
        });
        
        $('#bttnReport1').click(function(){
            fnBuscaLlamadasTienda();
        });
        $('#bttnReport2').click(function(){
            fnBuscaLlamadasOperador();
        });
        $('#bttnReport3').click(function(){
            fnBuscaLlamadasCliente();
        });
        /*
          modifica por darwin rosero 
          a qui se egrega este evento para que 
          llame al metodo que muestra los datos 
          de la ventana campañas 

        */
         $('#bttnReport4').click(function(){
            fnBuscaCampaniasCliente();
        });
    });
    
    function fnCambFechaFiltro(){
        $('#fecha_cumples_basic').hide();
        $('#fecha_cumples_basic').val('');
        $('#selRangoMesCumplesDe').val('');
        $('#selRangoDiaCumplesDe').val('');
        $('#selRangoMesCumplesHasta').val('');
        $('#selRangoDiaCumplesHasta').val('');
        $('#divFechaRangoCumples').hide();
        if($('#radMes').is(':checked')){
            $('#fecha_cumples_basic').show();
        }else{
            $('#divFechaRangoCumples').show();
        }
    }

    function fnShowcontactos()
    {
        
    //$("#reportecontactos").dialog('open');

    
    $('#divReport5').load('index.php?module=cont__centro_llamadas&action=verconctos');


    }
    
    /**
     * 
     * @param {type} value
     * @returns {undefined}
     */
    function fnGestionEstado(value){
        $('#divTdProxLlamadas').parent().prev().children().prop('style','display:none;');
        $('#divTdProxLlamadas').hide();
        fnCleanProxLl();
        switch(value){
            case "a3714054-b810-ac7f-2321-55c6f0432000":
                $('#divTdProxLlamadas').parent().prev().children().prop('style','display:block;');
                $('#divTdProxLlamadas').show();
                break;
        }
    }
    
    /**
     * 
     * @returns {undefined}
     */
    function fnCleanProxLl(){
        $('#txtFechaDesdeProxLlamada').val('');
        $('#txtFechaHastaProxLlamada').val('');
    }
    
    /**
     * 
     * @param {type} objtd
     * @returns {undefined}
     */
    function fnCambiaHtmlProxLlamada(objtd){
        var html = "";
        html += "<div id='divTdProxLlamadas' style='display:none;'>";
        html += "   Desde:";
        html += "       <input type='text' id='txtFechaDesdeProxLlamada' name='txtFechaDesdeProxLlamada' style='width:100px !important;' readonly='readonly' maxlength='10' />";
        html += "   <br/>";
        html += "   Hasta: ";
        html += "       <input type='text' id='txtFechaHastaProxLlamada' name='txtFechaHastaProxLlamada' style='width:100px !important;' readonly='readonly' maxlength='10' />";
        html += "</div>";
        $(objtd).html(html);
    }
    
    /**
     * 
     * @param {type} objtd
     * @returns {undefined}
     */
    function fnCambiaHtmlFechaCreacion(objtd){
        var html = "";
        html += "<div id='divTdFechaCreacion'>";
        html += "   Desde:";
        html += "       <input type='text' id='txtFechaDesdeCreacion' name='txtFechaDesdeCreacion' style='width:100px !important;' readonly='readonly' maxlength='10' />";
        html += "   <br/>";
        html += "   Hasta: ";
        html += "       <input type='text' id='txtFechaHastaCreacion' name='txtFechaHastaCreacion' style='width:100px !important;' readonly='readonly' maxlength='10' />";
        html += "</div>";
        $(objtd).html(html);
    }
    
    /**
     * 
     * @returns {undefined}
     */
    function fnCleanCreacion(){
        $('#txtFechaDesdeCreacion').val('');
        $('#txtFechaHastaCreacion').val('');
    }
    
    
    /**
     * 
     * @param {type} idcontactos
     * @param {type} firstname
     * @param {type} phonehome
     * @param {type} phonemobile
     * @param {type} phonework
     * @param {type} nametienda
     * @param {type} clientevip
     * @returns {undefined}
     */
    function fnShowGestion(idcontactos,firstname,phonehome,phonemobile,phonework,
            nametienda,clientevip,fechacumples,idtienda,emailp,offset,cedula,frequenciaContacto,tipoContacto,tipoInformacionNormal,tipoInformacion){
        $('#hdnoffset').val(offset);
        // set background row
        $('.class_bck').each(function(){
            $(this).removeClass('class_bck')
            $(this).prop('style','')
        });
        $('#trRowBody'+offset).addClass('class_bck');
        $('#trRowBody'+offset).prop('style','background-color:#FBFBC0');
        
        $('#hdnidcontacto').val(idcontactos);
        $('#spnFirstName').html(firstname);
        $('#txtFirstName').val(firstname);
        
        $('#spnTelCasa').html(phonehome);
        $('#txtTelCasa').val(phonehome);
        
        $('#spnTelCelu').html(phonemobile);
        $('#txtTelCelu').val(phonemobile);
        
        $('#spnTelTrabajo').html(phonework);
        $('#txtTelTrabajo').val(phonework);
        
        $('#spnTienda').html(nametienda);
        $('#selTienda').val(idtienda);
        
        $('#spnVip').html((clientevip=='1'?'Si':'No'));
        $('#selVip').val(clientevip);
        
        $('#spnCumples').html("");
        if(fechacumples!=""){
            $('#spnCumples').html(fnGetMesSpn(fechacumples.split("-")[1])+' '+fechacumples.substring(8));
        }
        
        var arrcum = fechacumples.split('-');
        $('#selMesCumples').val(parseInt(arrcum[1]));
        $('#selDiaCumples').val(parseInt(arrcum[2]));
        
        $('#spnEmailP').html(emailp);
        $('#txtEmailP').val(emailp);
        
        $('#spnCedula').html(cedula);
        $('#txtCedula').val(cedula);
        
        // open dialog
        $('#divGestionCallcenter').dialog('open');
        // cargamos la info de ventas
        fnLoadInfoVentas(idcontactos);
        $('#spnFrecuenciaContacto').html(frequenciaContacto);
        $('#selFrecuenciaContacto').val(frequenciaContacto);

        $('#spnTipoContacto').html(tipoContacto);
        $('#selTipoContacto').val(tipoContacto);


        /*
          modificado por : darwin rosero 
          fecha: enero/21/2016
          se cambian estos valores Para poder tener los dos 
          tipos de select el normal y el multiple
        */

        $('#spnTipoInformacionNormal').html(tipoInformacionNormal);
        $('#selTipoInformacionNormal').val(tipoInformacionNormal);


        /*
          añadido por : darwin rosero 
          fecha: enero/21/2016
          se toma el valor tipoInformacion se convierte
          en un array separandolo por las comas de cada 
          palabra con la funcion split  que trae este string 
          y mandamos este array a la funcion  fnAcomodarOpciones
        */
        tipoInformacion = tipoInformacion.split(",");
        tipoInformacionLabel=fnAcomodarOpciones('selTipoInformacionMultiple',tipoInformacion);

         /*
           añadido por : darwin rosero 
           fecha: enero/21/2016
           se agregra esta linea para mostrar  en label los datos  que se encuentra hasta ahora 
           
         */
        $('#spnTipoInformacionMultiple').html(tipoInformacionLabel);
         
    }
    /*
      añadido por : darwin rosero 
      fecha: enero/21/2016
      esta funcion recive dos parametros  idselect y arrInformacion
      el primero es el id del select multiple que queremos selecionar y 
      el segundo es un array con los datos a seleccionar 

      idselect:id del select multiple 
      arrInformacion: array con los datos a selecionar

    */
   function fnAcomodarOpciones(idSelect,arrInformacion)
    {
         // a qui se asigana a esta variable el primer valor del arraglo que se manda
         tipoLabel=arrInformacion[0].replace(/[^a-zA-Z 0-9.]+/g,'');
         //luego recorremos todas las opciones del select 
         $('#'+idSelect+' option ').each(function(i, sel){ 
            /*se crea este for para rrecorrer el arreglo y compararlo con las opciones 
              del select 
            */
             for(i=0;i<arrInformacion.length;i++){
                  /*cada item o palabra del arreglo  le devemos quitar los ^palabra ^
                    ya que de esta manera no lo manda sugarcrm y toca quitarlo para poder comparar 
                    la palabra con los item a si que la quitamos con replace
                  */
                  nuevaInformacion=arrInformacion[i].replace(/[^a-zA-Z 0-9.]+/g,'');
                 
                  //luego comparamos este dato con la opcion en este momente del ciclo 
                  if(nuevaInformacion==$(sel).val()){
                       /*si no estamos por el primer ciclo vamos concatenando 
                        las palabras del arreglo en la variable tipoLabel 
                       */
                      if(arrInformacion[0]!=arrInformacion[i]){
                            tipoLabel+=","+nuevaInformacion;
                          }
                    
                     //si se cumple el if se selecionan
                     $(sel).attr("selected","selected");
                  }
              }
             
            });
         return tipoLabel;
    }




    
    function fnSaveGestion(){
        // validamos los datos a enviar
        if($('#selOpciones').val()==''){
            alert('Debe seleccionar una opcion de gestion, proceso abortado');
            return;
        }
        if($('#selOpciones').val()=='a3714054-b810-ac7f-2321-55c6f0432000'){
            if($('#txtFechaProximaLlamada').val()==''){
                alert('Debe seleccionar una fecha de proxima llamada, proceso abortado');
                return;
            }
        }
        
        //
        $('#frmGestionCallcenter').append('<input type="hidden" name="action" value="saveGestionCallcenter" />');
        $.ajax({
            url: "index.php?module=cont__centro_llamadas",
            type:'POST',
            data: "input_type=JSON&response_type=JSON&to_pdf:true&"+$('#frmGestionCallcenter').serialize(),
            dataType:'json',
            beforeSend:function(){
                $('#bttnSubmit').prop('disabled','disabled').addClass('ui-state-disabled');
                $('#divPreloadGestionCallcenter').html("<img src='themes/default/images/bar_loader.gif'/><br/>Guardando informaci&oacute;n...");
            },
            success: function(msg){
                
                $('#divPreloadGestionCallcenter').html("");
                if(msg!=null && msg.msj!=null){
                    var arrpag = $('.pageNumbers').html().split('-');
                    arrpag = arrpag[0].trim().replace("(", "");
                    arrpag = parseInt(arrpag.trim());
                    arrpag = (parseInt(arrpag) - 1);
                    alert(msg.msj);
                    $('#search_form').append('<input type="hidden" name="cont__centro_llamadas2_CONT__CENTRO_LLAMADAS_offset" value="'+arrpag+'">');
                    $('#search_form').attr('action',$('#search_form').attr('action')+'&offset='+$('#hdnoffset').val())
                    $('#search_form').submit();
                }else{
                    alert("Error en el proceso");
                }
            }
        });
    }
    
    function fnGetMesSpn(mes){
        if(mes=="")
            return "";
        switch(parseInt(mes)){
            case 1: return "Enero";
            case 2: return "Febrero";
            case 3: return "Marzo";
            case 4: return "Abril";
            case 5: return "Mayo";
            case 6: return "Junio";
            case 7: return "Julio";
            case 8: return "Agosto";
            case 9: return "Septiembre";
            case 10: return "Octubre";
            case 11: return "Noviembre";
            case 12: return "Diciembre";
        }
    }
    
    /**
     * 
     * @param {type} idcontactos
     * @returns {undefined}
     */
    function fnLoadInfoVentas(idcontactos){
        // cargamos la gestion d callcenter
        fnLoadGestionCallcenter(idcontactos);
        // consultamos via ajax el html de la plantilla
        $.ajax({
            url: "index.php?module=cont__centro_llamadas",
            type:'POST',
            data: {action:'getInfoVentas',input_type: "JSON", response_type: "JSON",idcontactos:idcontactos,to_pdf:true},
            dataType:'json',
            beforeSend:function(){
                $('#ulDivTabsCompras').html("<img src='themes/default/images/ui-anim_basic_16x16.gif'/><br/>Cargando informaci&oacute;n...");
            },
            success: function(msg){
                $('#ulDivTabsCompras').html("");
                if(msg != null && msg.rows!=null){
                    if(msg.rows.length>0){
                        for(var k=0;k<msg.rows.length;k++){
                            $('#divTabsCompras').tabs('add', '#tab-'+k, msg.rows[k].fecha_documento+' - '+msg.rows[k].numero_documento);
                            var htmltabla = "";
                            htmltabla += "<div>";
                            htmltabla += "  <table width=100%>";
                            htmltabla += "      <tr>";
                            htmltabla += "          <th>Numero documento:</th>";
                            htmltabla += "          <td><i style='color:red;'>"+msg.rows[k].numero_documento+"</i></td>";
                            htmltabla += "          <th>Fecha document:</th>";
                            htmltabla += "          <td><i style='color:red;'>"+msg.rows[k].fecha_documento+"</i></td>";
                            htmltabla += "          <th>Cantidad Productos:</th>";
                            htmltabla += "          <td><i style='color:red;'>"+msg.rows[k].cantidad_productos+"</i></td>";
                            htmltabla += "      </tr>";
                            htmltabla += "  </table>";
                            htmltabla += "</div>";
                            // tabla detalles
                            if(msg.rows[k].detalle!=null){
                                htmltabla += "<div>";
                                htmltabla += "  <table width=100% class='list view'>";
                                htmltabla += "  <tr>";
                                htmltabla += "      <th>Referencia</th>";
                                htmltabla += "      <th>Descripcion</th>";
                                htmltabla += "      <th>Vr. Neto</th>";
                                htmltabla += "      <th>Talla</th>";
                                htmltabla += "      <th>Color</th>";
                                htmltabla += "      <th>Linea</th>";
                                htmltabla += "      <th>Coleccion</th>";
                                htmltabla += "  </tr>";
                                var total=0;
                                for(j=0;j<msg.rows[k].detalle.length;j++){
                                    htmltabla += "<tr class='oddListRowS1'>";
                                    htmltabla += "      <td>"+msg.rows[k].detalle[j].name_producto+"</td>";
                                    htmltabla += "      <td>"+msg.rows[k].detalle[j].desc_item_c+"</td>";
                                    htmltabla += "      <td>"+number_format(msg.rows[k].detalle[j].valor_neto)+"</td>";
                                    htmltabla += "      <td>"+msg.rows[k].detalle[j].talla+"</td>";
                                    htmltabla += "      <td>"+msg.rows[k].detalle[j].color+"</td>";
                                    htmltabla += "      <td>"+msg.rows[k].detalle[j].linea+"</td>";
                                    htmltabla += "      <td>"+msg.rows[k].detalle[j].colecciones+"</td>";
                                    htmltabla += "</tr>";
                                    total = (total + parseFloat(msg.rows[k].detalle[j].valor_neto));
                                }
                                htmltabla += "  <tr>";
                                htmltabla += "      <th>&nbsp;</th>";
                                htmltabla += "      <th>&nbsp;</th>";
                                htmltabla += "      <th>"+number_format(total)+"</th>";
                                htmltabla += "      <th>&nbsp;</th>";
                                htmltabla += "      <th>&nbsp;</th>";
                                htmltabla += "      <th>&nbsp;</th>";
                                htmltabla += "      <th>&nbsp;</th>";
                                htmltabla += "  </tr>";
                                htmltabla += "  </table>";
                                htmltabla += "</div>";
                            }
                            // sethtml ntab
                            $('#tab-'+k).html(htmltabla);
                            
                        }
                    }else{
                        $('#ulDivTabsCompras').html("<b>NO HAY DATOS PARA MOSTRAR</b>");
                    }
                }else{
                    if(msg.msj != null){
                        alert(msg.msj);
                    }else{
                        alert("Error en el proceso!");
                    }
                }
            }
        });
    }
    
    /**
     * 
     * @param {type} idcontactos
     * @returns {undefined}
     */
    function fnLoadGestionCallcenter(idcontactos,iddiv){
        $.ajax({
            url: "index.php?module=cont__centro_llamadas",
            type:'POST',
            data: {action:'getInfoCallcenter',input_type: "JSON", response_type: "JSON",idcontactos:idcontactos,to_pdf:true},
            dataType:'json',
            beforeSend:function(){
                if(iddiv == undefined){
                    $('#tabC2').html("<img src='themes/default/images/ui-anim_basic_16x16.gif'/><br/>Cargando informaci&oacute;n...");
                }else{
                    $('#divPreload'+iddiv).html("<img src='themes/default/images/ui-anim_basic_16x16.gif'/><br/>Cargando informaci&oacute;n...");
                }
            },
            success: function(msg){
                if(iddiv == undefined){
                    $('#tabC2').html("");
                }else{
                    $('#divPreload'+iddiv).html("");
                }
                if(msg != null && msg.rows!=null){
                    if(msg.rows.length>0){
                        var html = "";
                        html += "<table width=100% class='list view'>";
                        html += " <tr>";
                        html += "    <th>Fecha gestion</th>";
                        html += "    <th>Gestion</th>";
                        html += "    <th>Fecha Proxima llamada</th>";
                        html += "    <th>Hablo con</th>";
                        html += "    <th>Observaciones</th>";
                        html += " </tr>";
                        for(var i=0;i<msg.rows.length;i++){
                            html += "<tr>";
                            html += "   <td>"+msg.rows[i].date_entered+"</td>";
                            html += "   <td>"+msg.rows[i].gestion_name+"</td>";
                            html += "   <td>"+msg.rows[i].proxima_llamada+"</td>";
                            html += "   <td>"+msg.rows[i].hablo_con+"</td>";
                            html += "   <td><i style='font-size:8pt;'>"+msg.rows[i].description+"</i></td>";
                            html += "</tr>";
                        }
                        html += "</table>";
                        if(iddiv!=undefined){
                            $('#divBody'+iddiv).html(html);
                        }else{
                            $('#tabC2').html(html);
                        }
                    }else{
                        if(iddiv!=undefined){
                            $('#'+iddiv).html("NO HAY DATOS DE GESTION");
                        }else{
                            $('#tabC2').html("NO HAY DATOS DE GESTION");
                        }
                    }
                }else{
                    if(msg.msj != null){
                        alert(msg.msj);
                    }else{
                        alert("Error em el proceso!");
                    }
                }
            }
        });
    }
    
    /**
     * 
     * @param {type} valueopc
     * @returns {undefined}
     */
    function fnVerificaOpc(valueopc){
        $('#trProximaLlamada').hide();
        $('#txtFechaProximaLlamada').val('');
        $('#spnFirstName,#spnTelCasa,#spnTelCelu,#spnTelTrabajo,#spnTienda,#spnVip,#spnCumples,#spnEmailP').show();
        $('#txtFirstName,#txtTelCasa,#txtTelCelu,#txtTelTrabajo,#selTienda,#selVip,#divCumples,#txtEmailP').hide();
        switch(valueopc){
            case "a3714054-b810-ac7f-2321-55c6f0432000":
                $('#trProximaLlamada').show('',500);
                break;
            case "ef2cb3bd-2798-c655-3b2f-55f265e2aff4":
                fnEditInlineField();
                break;
        }
    }
    
    /**
     * 
     * @param {type} number
     * @param {type} decimals
     * @param {type} dec_point
     * @param {type} thousands_sep
     * @returns {unresolved}
     */
    function number_format(number, decimals, dec_point, thousands_sep) {
        number = (number + '')
          .replace(/[^0-9+\-Ee.]/g, '');
        var n = !isFinite(+number) ? 0 : +number,
          prec = !isFinite(+decimals) ? 0 : Math.abs(decimals),
          sep = (typeof thousands_sep === 'undefined') ? ',' : thousands_sep,
          dec = (typeof dec_point === 'undefined') ? '.' : dec_point,
          s = '',
          toFixedFix = function(n, prec) {
            var k = Math.pow(10, prec);
            return '' + (Math.round(n * k) / k)
              .toFixed(prec);
          };
        // Fix for IE parseFloat(0.55).toFixed(0) = 0;
        s = (prec ? toFixedFix(n, prec) : '' + Math.round(n))
          .split('.');
        if (s[0].length > 3) {
          s[0] = s[0].replace(/\B(?=(?:\d{3})+(?!\d))/g, sep);
        }
        if ((s[1] || '')
          .length < prec) {
          s[1] = s[1] || '';
          s[1] += new Array(prec - s[1].length + 1)
            .join('0');
        }
        return s.join(dec);
    }
    
    /**
     * 
     * @returns {undefined}
     */
    function fnCenterDialog(){
        $('#divConfigCampania').dialog('widget').position({
            my: "center", at: "center", of: window
        });
    }
    
    /**
     * 
     * @param {type} idcontacto
     * @returns {undefined}
     */
    function fnShowHistorialGestion(idcontacto){
        $('#divHistorialGestion').dialog('open');
        fnLoadGestionCallcenter(idcontacto,'HistorialGestion');
    }
    
    /**
     * 
     * @returns {undefined}
     */
    function fnShowReportes(){
        $('#divHistorialReporteCallcenter').dialog('open');
        // busca los 3 reportes
        fnBuscaLlamadasTienda();
        fnBuscaLlamadasOperador();
        fnBuscaLlamadasCliente();
        fnShowcontactos();
         /*
          modifica por darwin rosero 
          a qui se egrega este metodo que muestra los datos 
          de la ventana campañas 

        */
        fnBuscaCampaniasCliente();
    }
    
    function fnBuscaLlamadasTienda(){
        $.ajax({
            url: "index.php?module=cont__centro_llamadas",
            type:'POST',
            data: {action:'getReportLlamadasTienda',input_type: "JSON", response_type: "JSON",to_pdf:true,fecha_desde:$('#txtFechaDesdeReport1').val(),fecha_hasta:$('#txtFechaHastaReport1').val()},
            dataType:'json',
            beforeSend:function(){
                $('#divBodyReport1').html("");
                $('#divExport_1').hide();
                $('#divPreloadReport1').html("<img src='themes/default/images/bar_loader.gif'/><br/>Cargando informaci&oacute;n...");
            },
            success: function(msg){
                $('#divExport_1').show();
                $('#divPreloadReport1').html("");
                if(msg!=null && msg.rows != null){
                    var str = "<table width=100% class='list view'>";
                        if(msg.rows!=null && msg.rows.length>0){
                            $(msg.rows[0]).each(function(key,value){
                                var cont_o = 0;
                                var cont_ci = 1;
                                str += "    <tr>";
                                var value_22 = value;
                                for (key_2 in value) {
                                    if(key_2.indexOf('__opc') > 0){
                                        if(cont_o > 0 && cont_o % 3 == 0){
                                            str += "    </tr>";
                                            cont_o = 0;
                                        }
                                        str += "    <th>";
                                        str += "        "+cont_ci+'-'+key_2.substring(0,key_2.indexOf('__opc'));
                                        /*for (key_22 in value_22) {
                                            if(key_22.indexOf('__efectiva') > 0){
                                                if(key_22.substring(0,key_22.indexOf('__efectiva')) == 
                                                   key_2.substring(0,key_2.indexOf('__opc'))     
                                                ){
                                            
                                                    str += "    <span style='border-style:solid;border-width:1px;width:50px;height;10px;background-color:#DCF9E4;'>&nbsp;&nbsp;&nbsp;</span>";
                                                    break;
                                                }
                                            }
                                        }*/
                                        str += "    </th>";
                                        cont_ci ++;
                                        cont_o ++;
                                    }
                                }
                                str += "    </tr>";
                            });
                        }
                        str += "</table>";
                    str += "<table width=100% class='list view'>";
                    if(msg.rows.length>0){
                        str += "<tr class='oddListRowS1'>";
                        str += "    <th>Tienda</th>";
                        str += "    <th>Llamadas</th>";
                        // recorremos las opc
                        cont_o = 1;
                        if(msg.rows!=null && msg.rows.length>0){
                            $(msg.rows[0]).each(function(key,value){
                                for (key_2 in value) {
                                    if(key_2.indexOf('__opc') > 0){
                                        str += "    <th>"+cont_o+"</th>";
                                        cont_o++;
                                    }
                                }
                            });
                        }
                        str += "    <th>Efectivas</th>";
                        str += "    <th>Porcentaje %</th>";
                        str += "</tr>";
                        var t_1 = 0;
                        var t_2 = 0;
                        var t_3 = 0;
                        for(var i=0;i<msg.rows.length;i++){
                            t_1 = (t_1 + parseFloat(msg.rows[i].total_llamadas));
                            t_2 = (t_2 + parseFloat(msg.rows[i].total_llamadas_efectivas));
                            t_3 = (t_3 + parseFloat(msg.rows[i].porcentaje));
                            str += "<tr class='oddListRowS1'>";
                            str += "    <td>"+msg.rows[i].name+"</td>";
                            str += "    <td>"+number_format(msg.rows[i].total_llamadas)+"</td>";
                            $(msg.rows[i]).each(function(key,value){
                                var value_22 = value;
                                for (key_2 in value) {
                                    if(key_2.indexOf('__opc') > 0){
                                        var strb_k = '';
                                        /*for (key_22 in value_22) {
                                            if(key_22.indexOf('__efectiva') > 0){
                                                if(key_22.substring(0,key_22.indexOf('__efectiva')) == 
                                                   key_2.substring(0,key_2.indexOf('__opc'))     
                                                ){
                                            
                                                    strb_k = 'background:#DCF9E4';
                                                    break;
                                                }
                                            }
                                        }*/
                                        str += "    <td style='"+strb_k+"'>"+(value[key_2]==0?'':value[key_2]);
                                        str += "    </td>";
                                    }
                                }
                            });
                            str += "    <td style='background:#DCF9E4;'>"+number_format(msg.rows[i].total_llamadas_efectivas)+"</td>";
                            str += "    <td style='background:#DCF9E4;'>"+number_format(msg.rows[i].porcentaje,2)+"</td>";
                            str += "</tr>";
                        }
                        str += "<tr class='oddListRowS1'>";
                        str += "    <th>&nbsp;</th>";
                        str += "    <th>"+number_format(t_1)+"</th>";
                        if(msg.rows!=null && msg.rows.length>0){
                            $(msg.rows[0]).each(function(key,value){
                                for (key_2 in value) {
                                    if(key_2.indexOf('__opc') > 0){
                                        str += "    <th>&nbsp;</th>";
                                    }
                                }
                            });
                        }
                        str += "    <th>"+number_format(t_2)+"</th>";
                        str += "    <th>&nbsp;</th>";
                        str += "</tr>";
                    }else{
                        str += "<tr><th>NO HAY DATOS PARA MOSTRAR</th></tr>";
                    }
                    str += "</table>";
                    $('#divBodyReport1').html(str);
                }else{
                    alert("Error en el proceso");
                }
            }
        });
    }
    
    /**
     * 
     * @returns {undefined}
     */
    function fnBuscaLlamadasOperador(){
        $.ajax({
            url: "index.php?module=cont__centro_llamadas",
            type:'POST',
            data: {action:'getReportLlamadasOperador',input_type: "JSON", response_type: "JSON",to_pdf:true,fecha_desde:$('#txtFechaDesdeReport2').val(),fecha_hasta:$('#txtFechaHastaReport2').val()},
            dataType:'json',
            beforeSend:function(){
                $('#divBodyReport2').html("");
                $('#divExport_2').hide();
                $('#divPreloadReport2').html("<img src='themes/default/images/bar_loader.gif'/><br/>Cargando informaci&oacute;n...");
            },
            success: function(msg){
                $('#divExport_2').show();
                $('#divPreloadReport2').html("");
                if(msg!=null && msg.rows != null){
                    var str = "<table width=100% class='list view'>";
                        if(msg.rows!=null && msg.rows.length>0){
                            $(msg.rows[0]).each(function(key,value){
                                var cont_o = 0;
                                var cont_ci = 1;
                                str += "    <tr>";
                                var value_22 = value;
                                for (key_2 in value) {
                                    if(key_2.indexOf('__opc') > 0){
                                        if(cont_o > 0 && cont_o % 3 == 0){
                                            str += "    </tr>";
                                            cont_o = 0;
                                        }
                                        str += "    <th>";
                                        str += "        "+cont_ci+'-'+key_2.substring(0,key_2.indexOf('__opc'));
                                        /*for (key_22 in value_22) {
                                            if(key_22.indexOf('__efectiva') > 0){
                                                if(key_22.substring(0,key_22.indexOf('__efectiva')) == 
                                                   key_2.substring(0,key_2.indexOf('__opc'))     
                                                ){
                                            
                                                    str += "    <span style='border-style:solid;border-width:1px;width:50px;height;10px;background-color:#DCF9E4;'>&nbsp;&nbsp;&nbsp;</span>";
                                                    break;
                                                }
                                            }
                                        }*/
                                        str += "    </th>";
                                        cont_ci ++;
                                        cont_o ++;
                                    }
                                }
                                str += "    </tr>";
                            });
                        }
                        str += "</table>";
                    str += "<table width=100% class='list view'>";
                    if(msg.rows.length>0){
                        str += "<tr class='oddListRowS1'>";
                        str += "    <th>Operador</th>";
                        str += "    <th>Llamadas</th>";
                        // recorremos las opc
                        cont_o = 1;
                        if(msg.rows!=null && msg.rows.length>0){
                            $(msg.rows[0]).each(function(key,value){
                                for (key_2 in value) {
                                    if(key_2.indexOf('__opc') > 0){
                                        str += "    <th>"+cont_o+"</th>";
                                        cont_o++;
                                    }
                                }
                            });
                        }
                        str += "    <th>Efectivas</th>";
                        str += "    <th>Porcentaje %</th>";
                        str += "</tr>";
                        var t_1 = 0;
                        var t_2 = 0;
                        var t_3 = 0;
                        for(var i=0;i<msg.rows.length;i++){
                            t_1 = (t_1 + parseFloat(msg.rows[i].total_llamadas));
                            t_2 = (t_2 + parseFloat(msg.rows[i].total_llamadas_efectivas));
                            t_3 = (t_3 + parseFloat(msg.rows[i].porcentaje));
                            str += "<tr class='oddListRowS1'>";
                            str += "    <td>"+msg.rows[i].name+"</td>";
                            str += "    <td>"+number_format(msg.rows[i].total_llamadas)+"</td>";
                            $(msg.rows[i]).each(function(key,value){
                                var value_22 = value;
                                for (key_2 in value) {
                                    if(key_2.indexOf('__opc') > 0){
                                        var strb_k = '';
                                        /*for (key_22 in value_22) {
                                            if(key_22.indexOf('__efectiva') > 0){
                                                if(key_22.substring(0,key_22.indexOf('__efectiva')) == 
                                                   key_2.substring(0,key_2.indexOf('__opc'))     
                                                ){
                                            
                                                    strb_k = 'background:#DCF9E4';
                                                    break;
                                                }
                                            }
                                        }*/
                                        str += "    <td style='"+strb_k+"'>"+(value[key_2]==0?'':value[key_2]);
                                        str += "    </td>";
                                    }
                                }
                            });
                            str += "    <td style='background:#DCF9E4;'>"+number_format(msg.rows[i].total_llamadas_efectivas)+"</td>";
                            str += "    <td style='background:#DCF9E4;'>"+number_format(msg.rows[i].porcentaje,2)+"</td>";
                            str += "</tr>";
                        }
                        str += "<tr class='oddListRowS1'>";
                        str += "    <th>&nbsp;</th>";
                        str += "    <th>"+number_format(t_1)+"</th>";
                        if(msg.rows!=null && msg.rows.length>0){
                            $(msg.rows[0]).each(function(key,value){
                                for (key_2 in value) {
                                    if(key_2.indexOf('__opc') > 0){
                                        str += "    <th>&nbsp;</th>";
                                    }
                                }
                            });
                        }
                        str += "    <th>"+number_format(t_2)+"</th>";
                        str += "    <th>&nbsp;</th>";
                        str += "</tr>";
                    }else{
                        str += "<tr><th>NO HAY DATOS PARA MOSTRAR</th></tr>";
                    }
                    str += "</table>";
                    $('#divBodyReport2').html(str);
                }else{
                    alert("Error en el proceso");
                }
            }
        });
    }
    
    /**
     * 
     * @returns {undefined}
     */
    function fnBuscaLlamadasCliente(){
        $.ajax({
            url: "index.php?module=cont__centro_llamadas",
            type:'POST',
            data: {action:'getReportLlamadasClientes',input_type: "JSON", response_type: "JSON",to_pdf:true,fecha_desde:$('#txtFechaDesdeReport3').val(),fecha_hasta:$('#txtFechaHastaReport3').val()},
            dataType:'json',
            beforeSend:function(){
                $('#divBodyReport3').html("");
                $('#divExport_3').hide();
                $('#divPreloadReport3').html("<img src='themes/default/images/bar_loader.gif'/><br/>Cargando informaci&oacute;n...");
            },
            success: function(msg){
                $('#divExport_3').show();
                $('#divPreloadReport3').html("");
                if(msg!=null && msg.rows != null){
                    var str = "<table width=100% class='list view'>";
                    if(msg.rows.length>0){
                        str += "<tr class='oddListRowS1'>";
                        str += "    <th>Tienda</th>";
                        str += "    <th>Total</th>";
                        str += "    <th>Total rango fecha</th>";
                        str += "</tr>";
                        var t_1 = 0;
                        var t_2 = 0;
                        var t_3 = 0;
                        for(var i=0;i<msg.rows.length;i++){
                            t_1 = (t_1 + parseFloat(msg.rows[i].cantidad_clientes));
                            t_2 = (t_2 + parseFloat(msg.rows[i].total_en_rango));
                            str += "<tr class='oddListRowS1'>";
                            str += "    <td>"+msg.rows[i].name+"</td>";
                            str += "    <td>"+number_format(msg.rows[i].cantidad_clientes)+"</td>";
                            str += "    <td>"+number_format(msg.rows[i].total_en_rango)+"</td>";
                            str += "</tr>";
                        }
                        str += "<tr id= class='oddListRowS1'>";
                        str += "    <th>&nbsp;</th>";
                        str += "    <th>"+number_format(t_1)+"</th>";
                        str += "    <th>"+number_format(t_2)+"</th>";
                        str += "</tr>";
                    }else{
                        str += "<tr><th>NO HAY DATOS PARA MOSTRAR</th></tr>";
                    }
                    str += "</table>";
                    $('#divBodyReport3').html(str);
                }else{
                    alert("Error en el proceso");
                }
            }
        });
    }
    
     function fnBuscaCampaniasCliente(){
        $.ajax({
            url: "index.php?module=cont__centro_llamadas",
            type:'POST',
            data: {action:'getReportCampanasClientes',input_type: "JSON", response_type: "JSON",to_pdf:true,  
                   fecha_desde:$('#txtFechaDesdeReport4').val(),fecha_hasta:$('#txtFechaHastaReport4').val(),
                   tipocontacto_c:$('#selTipoContacto1').val(),frecuenciacontacto_c:$('#selFrecuencia').val(),
                   tipoinformacionsm_c:$('#selTipoInformacion').val()

                   
                   },
            dataType:'json',
            
            beforeSend:function(){
                $('#divBodyReport4').html("");
                $('#divExport_4').hide();
                $('#divPreloadReport4').html("<img src='themes/default/images/bar_loader.gif'/><br/>Cargando informaci&oacute;n...");
            },
            success: function(msg){
                
                $('#divExport_4').show();
                $('#divPreloadReport4').html("");
                if(msg!=null && msg.rows != null){
                    var str = "<table width=100% class='list view'>";
                    if(msg.rows.length>0){
                        str += "<tr class='oddListRowS1'>";
                        str += "    <th>Tienda</th>";
                        str += "    <th>Total</th>";
                        str += "    <th>Total  tipo </th>";
                        str += "    <th>Total  periodo</th>";
                        str += "    <th>Total  informacion</th>";
                        str += "</tr>";
                        var t_1 = 0;
                        var t_2 = 0;
                        var t_3 = 0;
                        var t_4 = 0;
                        var t_5 = 0;
                        var t_6 = 0;
                        for(var i=0;i<msg.rows.length;i++)
                        {
                            t_1 = (t_1 + parseFloat(msg.rows[i].cantidad_clientes));
                            //t_2 = (t_2 + parseFloat(msg.rows[i].total_en_fecha));
                            t_4 = (t_4 + parseFloat(msg.rows[i].total_en_tipo));
                            t_5 = (t_5 + parseFloat(msg.rows[i].total_en_periodo));
                            t_6 = (t_6 + parseFloat(msg.rows[i].total_en_informacion));
                            str += "<tr class='oddListRowS1'>";
                            str += "    <td>"+msg.rows[i].name+"</td>";
                            str += "    <td>"+number_format(msg.rows[i].cantidad_clientes)+"</td>";
                            //str += "    <td>"+number_format(msg.rows[i].total_en_fecha)+"</td>";
                            str += "    <td>"+number_format(msg.rows[i].total_en_tipo)+"</td>";
                            str += "    <td>"+number_format(msg.rows[i].total_en_periodo)+"</td>";
                            str += "    <td>"+number_format(msg.rows[i].total_en_informacion)+"</td>";
                            str += "</tr>";
                        }
                        str += "<tr id= class='oddListRowS1'>";
                        str += "    <th>&nbsp;</th>";
                        str += "    <th>"+number_format(t_1)+"</th>";
                        //str += "    <th>"+number_format(t_2)+"</th>";
                        str += "    <th>"+number_format(t_4)+"</th>";
                        str += "    <th>"+number_format(t_5)+"</th>";
                        str += "    <th>"+number_format(t_6)+"</th>";
                        str += "</tr>";
                    }else{
                        str += "<tr><th>NO HAY DATOS PARA MOSTRAR</th></tr>";
                    }
                    str += "</table>";
                    $('#divBodyReport4').html(str);
                }else{
                    alert("Error en el proceso");
                }
                
            }
        });
    }





    
    function fnExportDoc(tipo,divnum){
        var action = null;
        if(divnum == 1){
            action = "getReportLlamadasTienda";
        }
        else{
            if(divnum == 2){
                action = "getReportLlamadasOperador";
            }
            else{
                if(divnum == 3){
                    action = "getReportLlamadasClientes";
                }
                else{
                if(divnum == 4){
                    action = "getReportCampanasClientes";
                }
                else{
                    if(divnum == 5){
                    action = "buscarcontactos";
                    tiendalist=$("#dataListTiendas").val();
                    tienda=tiendalist.split("/");
                    }

                }
              }
            }


        }

        


            
        $.ajax({
            url: "index.php?module=cont__centro_llamadas",
            type:'POST',
            data: {action:action,tipo:tipo,input_type: "JSON", response_type: "JSON",to_pdf:true,fecha_desde:$('#txtFechaDesdeReport'+divnum).val(),fecha_hasta:$('#txtFechaHastaReport'+divnum).val(),tipocontacto_c:$('#selTipoContacto1').val(),
                frecuenciacontacto_c:$('#selFrecuencia').val(),tipoinformacionsm_c:$('#selTipoInformacion').val(),tienda : tienda[0],
                    cumple : $("#dataListMes").val(),
                    fecha_1 : $("#fechaInicial").val(),
                    fecha_2 : $("#fechaFinal").val()
                    
                 

                 },
            dataType:'json',
            beforeSend:function(){
                $('#divPreloadReport'+divnum).html("<img src='themes/default/images/bar_loader.gif'/><br/>Generando archivo...");
            },
            success: function(msg){
                $('#divPreloadReport'+divnum).html("");
                
                if(msg.archivo_url != null){
                    window.open(msg.archivo_url,'_blank');
                }else{
                    alert("Error en el proceso");
                }
            }
        });
    }
    
    function fnEditInlineField(){
        // set opc
        $('#selOpciones').val('ef2cb3bd-2798-c655-3b2f-55f265e2aff4');
        // hidden field
        if($('#spnFirstName').is(':visible')){
            $('#spnFirstName,#spnTelCasa,#spnTelCelu,#spnTelTrabajo,#spnTienda,#spnVip,#spnCumples,#spnEmailP,#spnCedula,#spnFrecuenciaContacto,#spnTipoContacto,#spnTipoInformacionNormal,#spnTipoInformacionMultiple').hide();
            $('#txtFirstName,#txtTelCasa,#txtTelCelu,#txtTelTrabajo,#selTienda,#selVip,#divCumples,#txtEmailP,#txtCedula,#selFrecuenciaContacto,#selTipoContacto,#selTipoInformacionNormal,#selTipoInformacionMultiple').show();
        }else{
            $('#spnFirstName,#spnTelCasa,#spnTelCelu,#spnTelTrabajo,#spnTienda,#spnVip,#spnCumples,#spnEmailP,#spnCedula,#spnFrecuenciaContacto,#spnTipoContacto,#spnTipoInformacionNormal,#spnTipoInformacionMultiple').show();
            $('#txtFirstName,#txtTelCasa,#txtTelCelu,#txtTelTrabajo,#selTienda,#selVip,#divCumples,#txtEmailP,#txtCedula,#selFrecuenciaContacto,#selTipoContacto,#selTipoInformacionNormal,#selTipoInformacionMultiple').hide();
        }
    }
    {/literal}
</script>