<?php

/**
 * Products, Quotations & Invoices modules.
 * Extensions to SugarCRM
 * @package Advanced OpenSales for SugarCRM
 * @subpackage Products
 * @copyright SalesAgility Ltd http://www.salesagility.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU AFFERO GENERAL PUBLIC LICENSE
 * along with this program; if not, see http://www.gnu.org/licenses
 * or write to the Free Software Foundation,Inc., 51 Franklin Street,
 * Fifth Floor, Boston, MA 02110-1301  USA
 *
 * @author Salesagility Ltd <support@salesagility.com>
 */
require_once('include/MVC/Controller/SugarController.php');
class Cont__centro_llamadasController extends SugarController {

    function action_listview(){
        // consultamos los templates disponibles
        $arrData = $this->getOpcRespuestasList();
        $this->view_object_map['dataListOpcRespuestas'] = $arrData;
        // consiultamos las tiendas
        $arrData = $this->getStu_tiendas();
        $this->view_object_map['dataListStuTiendas'] = $arrData;
        
        parent::action_listview();
    }
 /**
 * Comienza adiciones Reportes Darwin-Carlos
 * Parte 1-3 ref.00001a
 */

    function action_verconctos(){
        $this->view_object_map["listaTiendas"] = $this->getStuTiendas();
        $this->view="mostrar";
    }

     private function getStuTiendas(){
        try{
            $arrayCampos = array();
            $indexArray = 0;
            
            $db = DBManagerFactory::getInstance();

            $res = $db->query("SELECT id,name FROM stu_tiendas WHERE deleted=0;"); 

            while($row = $db->fetchByAssoc($res)){
                 $arrayCampos [] = array('idTienda' => $row["id"],
                                         'nombreTienda'=>$row["name"]);

                $indexArray++;
     
            }
           
            return $arrayCampos;
            
            /*echo json_encode($arrayCampos);
            exit();*/
        }catch(Exception $e){
           echo $ex;
        }
    }//Fin getStuTiendas

    private function traerarray($dato,$array,$total)
    {  

           $item="nada";
           for($i=1;$i<$total;$i++){
              
               if($array['rows'][$i]['nombre']==$dato){
                   $item=$i; 
                   
                }
            }
            return $item;

    }

   private function getStuNombresContactos(){
        try{
            $arrayCampos = array();
            $indexArray = 0;
            
            $db = DBManagerFactory::getInstance();

            $res = $db->query("SELECT first_name FROM contacts WHERE deleted=0;"); 

            while($row = $db->fetchByAssoc($res)){
                 $arrayCampos [] = array('nombresContacto'=>$row["first_name"]);

                $indexArray++;
     
            }
           
            return $arrayCampos;
            
            /*echo json_encode($arrayCampos);
            exit();*/
        }catch(Exception $e){
           echo $ex;
        }
    }//Fin getStuTiendas


    function action_buscartodosContactos(){
        $db = DBManagerFactory::getInstance();
            // sacamos las tiendas
            $res = $db->query("
                SELECT
                    tien.id,
                    tien.name,
                    COALESCE((
                        SELECT
                            COUNT(*)
                        FROM
                            stu_tiendas_contacts_c contiend
                                INNER JOIN
                                    contacts con ON
                                        contiend.stu_tiendas_contactscontacts_idb = con.id
                                
                        WHERE
                            con.deleted = 0 AND
                            contiend.deleted = 0 AND
                            contiend.stu_tiendas_contactsstu_tiendas_ida = tien.id
                    ),0) as cantidad_clientes
                FROM
                    stu_tiendas tien
                WHERE
                    tien.deleted = 0
            ");
            $arrResp = array();
            $cont_general = 0;
            while ($row = $db->fetchByAssoc($res)) {
                $arrResp['rows'][$cont_general]['id'] = $row['id'];
                $arrResp['rows'][$cont_general]['nombre'] = $row['name'];
                $arrResp['rows'][$cont_general]['cantidad_clientes'] = $row['cantidad_clientes'];
                $cont_general++;
            }
            echo json_encode($arrResp);
            exit();

    }

    function action_buscarcontactos()
    {
        $tienda=$_REQUEST['tienda'];
        
        $cumple=$_REQUEST['cumple'];
        /*$informacion=$_REQUEST['tipoInformacion'];
        $contacto=$_REQUEST['tipoContacto'];*/
        $fecha1=$_REQUEST['fecha_1'];
        $fecha2=$_REQUEST['fecha_2'];
        //$frecuncia=$_REQUEST['frecuenciaC'];

        if($fecha1== date("Y-m-d"))
        {
          $fecha1="2015-10-04"; 
        }
        /*
         c.do_not_call,
         c.phone_home,
         c.phone_mobile,
         c.phone_work,


        */

        $sql='SELECT  c.id,c.first_name as nombre,tienda.id,tienda.name as nombre_tienda,stu_tc.id, stu_tc.stu_tiendas_contactsstu_tiendas_ida,stu_tc.stu_tiendas_contactscontacts_idb, c.phone_mobile as celular, c.phone_home as telefonoFijo,c.do_not_call as noLlamar,c.phone_work as telefonoTrabajo, cc.id_c, cc.cedula_nit_c as cedula, cc.mes_cumpleanos_c as fecha_cumpleanos, ea.id, ea.email_address as email, eabr.id, eabr.email_address_id,
                                       cc.tipocontacto_c as tipo_contacto, cc.tipoinformacion_c as tipo_informacion, cc.frecuenciacontacto_c as frecuencia_contacto,cc.cliente_vip_c as clienteVip,c.date_entered as fechacreacion
                                       
                                       FROM contacts c 
                                       INNER JOIN 
                                       contacts_cstm  cc 
                                       ON 
                                       c.id= cc.id_c 
                                       INNER JOIN 
                                       stu_tiendas_contacts_c stu_tc 
                                       ON 
                                       c.id=stu_tc.stu_tiendas_contactscontacts_idb 
                                       INNER JOIN stu_tiendas tienda 
                                       ON 
                                       tienda.id=stu_tc.stu_tiendas_contactsstu_tiendas_ida 

                                     


                                       LEFT JOIN email_addr_bean_rel eabr 
                                       ON 
                                       c.id=eabr.bean_id 
                                       LEFT JOIN email_addresses ea 
                                       ON 
                                       ea.id=eabr.email_address_id';


       

            if(($tienda=="noSelTienda") && ($cumple!="noselmes")){
            
            $where=' WHERE 
                    cc.mes_cumpleanos_c="'.$cumple.'"';

              }

            if(($cumple=="noselmes") && ($tienda!="noSelTienda")){
                $where=' WHERE tienda.id="'.$tienda.'"';
            }

            

            if(($cumple!="noselmes") && ($tienda!="noSelTienda")){
         $where=' WHERE tienda.id="'.$tienda.'"
                                        AND  cc.mes_cumpleanos_c="'.$cumple.'"';
                 }

            
        
        /*
         
                                        AND  centroLamadas.date_entered >= "'.$fecha1.' 00:00:00" AND  
                                        centroLamadas.date_entered <= "'.$fecha2.' 23:59:59"
 
        */
                                    
       

        


        
        if(($tienda=="")&&($cumple=="")){
            $where='';
        }

        $sql=$sql.$where;

        //echo $sql;
                                     
    
        $res = $this->bean->db->query($sql);

//
        $mass=array();
        $cont_general = 1;

         
         $tiendasnombres=array();
         $nombrescontactos=array();
         $nombres=array();
          
         while ($row = $this->bean->db->fetchByAssoc($res)){
                //mescumpleaños,correo electronico,fecha de creacion,frecuencia_contacto,tipo_informacion,tipo_contacto,
              
                $nombres[$cont_general]=$row['nombre'];
                $mass['rows'][$cont_general]['nombre'] =$row['nombre'];
                $mass['rows'][$cont_general]['tienda'] =$row['nombre_tienda'];
                
                if($row['celular']!="")
                {
                     $mass['rows'][$cont_general]['celular'] =$row['celular'];
                }
                else
                {
                     $mass['rows'][$cont_general]['celular'] ="no tiene";
                }

                //$mass['rows'][$cont_general]['telefono'] =$row['telefonoFijo'];
                if($row['telefonoFijo']!="")
                {
                     $mass['rows'][$cont_general]['telefonoFijo'] =$row['telefonoFijo'];
                }
                else
                {
                     $mass['rows'][$cont_general]['telefonoFijo'] ="no tiene";
                }
                
                if($row['telefonoTrabajo']!="")
                {
                     $mass['rows'][$cont_general]['telefonoTrabajo'] =$row['telefonoTrabajo'];
                }
                else
                {
                     $mass['rows'][$cont_general]['telefonoTrabajo'] ="no tiene";
                }
                
                  if($row['noLlamar']==0)
                {
                  $mass['rows'][$cont_general]['noLlamar'] ="autorizo llamarme";
                }
                else
                {
                   $mass['rows'][$cont_general]['noLlamar'] ="no llamar";  
                }

                 if($row['clienteVip']==0)
                {
                  $mass['rows'][$cont_general]['clienteVip'] ="no es vip";
                }
                else
                {
                   $mass['rows'][$cont_general]['clienteVip'] ="es cliente vip";  
                }
                

                $mass['rows'][$cont_general]['cedula'] =$row['cedula'];
                $mass['rows'][$cont_general]['mescumplean'] =$row['fecha_cumpleanos'];
                if($row['email']!="")
                {
                     $mass['rows'][$cont_general]['correo'] =$row['email'];
                }
                else
                {
                     $mass['rows'][$cont_general]['correo'] ="no tiene";
                }
               
                $mass['rows'][$cont_general]['fecha_de_creacion'] =$row['fechacreacion'];
                $mass['rows'][$cont_general]['frecuencia_contacto'] =$row['frecuencia_contacto'];
                $mass['rows'][$cont_general]['tipo_informacion'] =$row['tipo_informacion'];
                $mass['rows'][$cont_general]['tipo_contacto'] =$row['tipo_contacto'];
                $mass['rows'][$cont_general]['cantidadUuariosTienda']="";

                $cont_general++;
          }

         //$nombres = array_unique($nombres);
          $masssinrepetidos=array();
          $nombrescontactos=$this->getStuNombresContactos();
          $cuentarep=0;
          
          $nombrecon="";
          $arradatos=array();
//
                   /* $item=$this->traerarray("ALMEIDA  AMIRA",$mass,$cont_general);
                    $arradatos['rows'][0]['cedula']=$mass['rows'][$item]['cedula']; 
                    $arradatos['rows'][0]['nombre']= $mass['rows'][$item]['nombre'];
                    $arradatos['rows'][0]['tienda']= $mass['rows'][$item]['tienda'];
                    $tiendasnombres[0]=$arradatos['rows'][$cuentarep]['tienda'];
                    $arradatos['rows'][0]['celular']= $mass['rows'][$item]['celular'];
                    $arradatos['rows'][0]['telefonoFijo']= $mass['rows'][$item]['telefonoFijo'];
                    $arradatos['rows'][0]['telefonoTrabajo']=$mass['rows'][$item]['telefonoTrabajo'];
                    $arradatos['rows'][0]['noLlamar']=$mass['rows'][$item]['noLlamar']; 
                    $arradatos['rows'][0]['clienteVip']=$mass['rows'][$item]['clienteVip'];
                    $arradatos['rows'][0]['mescumplean']= $mass['rows'][$item]['mescumplean'];
                    $arradatos['rows'][0]['correo']= $mass['rows'][$item]['correo'];                                                           
                    $arradatos['rows'][0]['fecha_de_creacion']= $mass['rows'][$item]['fecha_de_creacion'];
                    $arradatos['rows'][0]['frecuencia_contacto']= $mass['rows'][$item]['frecuencia_contacto'];
                    $arradatos['rows'][0]['tipo_informacion']= $mass['rows'][$item]['tipo_informacion'];
                    $arradatos['rows'][0]['tipo_contacto']= $mass['rows'][$item]['tipo_contacto'];*/
        $conteo=0;
        $item=0;
        $conteo=0;
        $names=array();
        $nombresito="";

        /*
           foreach ($nombrescontactos as $nombrescontacto) {
                 
                for($i=1;$i<=$cont_general;$i++) {
                   //echo $nombres[$i];
                 if($nombres[$i]==$nombrescontacto['nombresContacto']){
                    $cedula=$mass['rows'][$i]['cedula']; 
                    $nombre=$mass['rows'][$i]['nombre'];
                    $tienda=$mass['rows'][$i]['tienda'];
                    //$arradatos['rows'][$cuentarep]['tienda'];
                    $celular=$mass['rows'][$i]['celular'];
                    $telefonoFijo=$mass['rows'][$i]['telefonoFijo'];
                    $telefonoTrabajo=$mass['rows'][$i]['telefonoTrabajo'];
                    $noLlamar=$mass['rows'][$i]['noLlamar']; 
                   
                 }
                   
                }
                    $arradatos['rows'][$cuentarep]['cedula']= $cedula; 
                    $arradatos['rows'][$cuentarep]['nombre']= $nombre;
                    $arradatos['rows'][$cuentarep]['tienda']= $tienda;
                    
                    $arradatos['rows'][$cuentarep]['celular']= $celular;
                    $arradatos['rows'][$cuentarep]['telefonoFijo']= $telefonoFijo;
                    $arradatos['rows'][$cuentarep]['telefonoTrabajo']=$telefonoTrabajo;
                    $arradatos['rows'][$cuentarep]['noLlamar']=$noLlamar; 

                    $cuentarep++;

               // $names[]=$nombresito;
          }


        */

          /*foreach ($nombrescontactos as $nombrescontacto) {
                 
                for($i=0;$i<=$cont_general;$i++) {
                   //echo $nombres[$i];
                 if($nombres[$i]==$nombrescontacto['nombresContacto']){
                    if($nombresito!=$nombres[$i]){
                    $nombresito=$nombrescontacto['nombresContacto'];
                     }
                 }
                   
                }
                 //echo $nombresito."\n";
                $names[]=$nombresito;

          }*/


        foreach ($nombrescontactos as $nombrescontacto) {
                

               $item=$this->traerarray($nombrescontacto['nombresContacto'],$mass,$cont_general);
              /*if($nombrescontacto['nombresContacto']=="ALMEIDA  AMIRA")
               {
                echo "algo pasa"."el item es ".$item;
               }*/
                  $conteo++;         
                if($item!="nada")
                {
                    //echo "algo pasa 2"."el item es 2 ".$item;
                    
                    //$arradatos[]=$mass['rows'][$item];
                    $arradatos['rows'][$cuentarep]['cedula']=$mass['rows'][$item]['cedula']; 
                    $arradatos['rows'][$cuentarep]['nombre']= $mass['rows'][$item]['nombre'];
                    $arradatos['rows'][$cuentarep]['tienda']= $mass['rows'][$item]['tienda'];
                    $tiendasnombres[$cuentarep]=$arradatos['rows'][$cuentarep]['tienda'];
                    $arradatos['rows'][$cuentarep]['celular']= $mass['rows'][$item]['celular'];
                    $arradatos['rows'][$cuentarep]['telefonoFijo']= $mass['rows'][$item]['telefonoFijo'];
                    $arradatos['rows'][$cuentarep]['telefonoTrabajo']=$mass['rows'][$item]['telefonoTrabajo'];
                    $arradatos['rows'][$cuentarep]['noLlamar']=$mass['rows'][$item]['noLlamar']; 
                    $arradatos['rows'][$cuentarep]['clienteVip']=$mass['rows'][$item]['clienteVip'];
                    $arradatos['rows'][$cuentarep]['mescumplean']= $mass['rows'][$item]['mescumplean'];
                    $arradatos['rows'][$cuentarep]['correo']= $mass['rows'][$item]['correo'];                                                           
                    $arradatos['rows'][$cuentarep]['fecha_de_creacion']= $mass['rows'][$item]['fecha_de_creacion'];
                    $arradatos['rows'][$cuentarep]['frecuencia_contacto']= $mass['rows'][$item]['frecuencia_contacto'];
                    $arradatos['rows'][$cuentarep]['tipo_informacion']= $mass['rows'][$item]['tipo_informacion'];
                    $arradatos['rows'][$cuentarep]['tipo_contacto']= $mass['rows'][$item]['tipo_contacto'];
                    $cuentarep++;
                    

                }
               
          }

        
          if(!isset($_REQUEST['tipo'])){
             $tiendas=$this->getStuTiendas();
             //$nombresContactos=$this->getStuNombresContactos();
             $contador=0;
             foreach ($tiendas as $tiendanom) {
                 $nombre="";
                 $cant=0;
                 foreach ($tiendasnombres as $tienda_nombre) {
                           if($tiendanom['nombreTienda']==$tienda_nombre)
                           {
                                $nombre=$tienda_nombre;
                                $cant++;
                           }

                 }
                 if($nombre!=""){

                  $datatienda['rows'][$contador]['nombre']=$nombre;
                  $datatienda['rows'][$contador]['cantidad']=$cant;
                  $contador++;
                  }

             }

             // $datatienda['rows'][0]['tienda'] =$cont_general;
             echo json_encode($datatienda);
          }
          else
          {     
          $this->generaArchivo($arradatos,$_REQUEST['tipo'],array('nombre','tienda','celular','telefonoFijo','telefonoTrabajo','noLlamar','clienteVip','cedula','mescumplean','correo','fecha_de_creacion','frecuencia_contacto','tipo_informacion','tipo_contacto'),"Reporte de Clientes");
          }
         exit();
         
        


    }
/*Finaliza adiciones Reportea Darwin-Carlos 
Parte 1-3 ref.00001a*/ 
  
    /**
     * consulta los opc respuestas
     * 
     * @author john jairo cortes garcia <john.cortes@syslab.so>
     * @date 14-08-2015
     * @return type
     * @throws Exception
     */
    private function getOpcRespuestasList(){
        try{
            $res = $this->bean->db->query(
                "
                    SELECT 
                        id,
                        CONCAT(UCASE(SUBSTRING(name, 1, 1)),LCASE(SUBSTRING(name, 2))) as name
                    FROM cont__opciones_respuestas 
                    WHERE deleted = 0
                    ORDER BY
                        name ASC
                "
            );
            $mass = array();

            while ($row = $this->bean->db->fetchByAssoc($res)) {
                $mass[] = $row;
            }
            return $mass;
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    
    /**
     * consulta los opc respuestas
     * 
     * @author john jairo cortes garcia <john.cortes@syslab.so>
     * @date 14-08-2015
     * @return type
     * @throws Exception
     */
    private function getStu_tiendas(){
        try{
            $res = $this->bean->db->query(
                "
                    SELECT 
                        id,
                        CONCAT(UCASE(SUBSTRING(name, 1, 1)),LCASE(SUBSTRING(name, 2))) as name
                    FROM stu_tiendas 
                    WHERE deleted = 0 
                    ORDER BY
                        name ASC
                "
            );
            $mass = array();

            while ($row = $this->bean->db->fetchByAssoc($res)) {
                $mass[] = $row;
            }
            return $mass;
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    
    /**
     * 
     * @return type
     * @throws Exception
     */
    public function action_getInfoVentas(){
        try{
            $db = DBManagerFactory::getInstance();
            $res = $db->query(
                "
                    SELECT 
                        stuv.name as numero_documento,
                        stuv.fecha_documento,
                        stuv.cantidad_productos,
                        det.name as name_producto,
                        det.valor_neto,
                        (
                            SELECT
                                name
                            FROM
                                stu_tallas
                            WHERE
                                id = det.stu_tallas_id_c
                        ) as talla,
                        (
                            SELECT
                                name
                            FROM
                                stu_colores
                            WHERE
                                id = det.stu_colores_id_c
                        ) as color,
                        (
                            SELECT
                                name
                            FROM
                                stu_linea
                            WHERE
                                id = det.stu_linea_id_c
                        ) as linea,
                        (
                            SELECT
                                name
                            FROM
                                stu_colecciones
                            WHERE
                                id = det.stu_colecciones_id_c
                        ) as colecciones,
                        csmt.desc_item_c
                    FROM 
                        stu_ventas stuv
                            INNER JOIN
                                stu_ventas_contacts_c vencon ON
                                    stuv.id = vencon.stu_ventas_contactsstu_ventas_idb
                            INNER JOIN
                                (
                                    stu_ventas_stu_ventas_detalle_c vendet 
                                        INNER JOIN
                                            (
                                                stu_ventas_detalle det 
                                                    INNER JOIN
                                                        aos_products_cstm csmt ON
                                                            det.aos_products_id_c = csmt.id_c
                                            )
                                                ON
                                                vendet.stu_ventas_stu_ventas_detallestu_ventas_detalle_idb = det.id
                                )
                                    ON
                                    stuv.id = vendet.stu_ventas_stu_ventas_detallestu_ventas_ida
                    WHERE 
                        stuv.deleted = 0 AND
                        vencon.stu_ventas_contactscontacts_ida = '".$_REQUEST['idcontactos']."'
                    ORDER BY
                        stuv.fecha_documento DESC
                "
            );
            $mass = array('rows'=>array());
            $cont = 0;
            $arrNDoc = array();
            while ($row = $db->fetchByAssoc($res)) {
                if(!in_array($row['numero_documento'],$arrNDoc)){
                    $mass['rows'][$cont]['numero_documento'] = $row['numero_documento'];
                    $mass['rows'][$cont]['fecha_documento'] = $row['fecha_documento'];
                    $mass['rows'][$cont]['cantidad_productos'] = $row['cantidad_productos'];
                    $mass['rows'][$cont]['detalle'][] = array(
                                                        'name_producto'=>($row['name_producto']),
                                                        'desc_item_c'=>($row['desc_item_c']),
                                                        'valor_neto'=>round($row['valor_neto']),
                                                        'talla'=>($row['talla']),
                                                        'color'=>($row['color']),
                                                        'linea'=>($row['linea']),
                                                        'colecciones'=>($row['colecciones'])
                                                    );
                    
                    array_push($arrNDoc, $row['numero_documento']);
                    $cont ++;
                }else{
                    $ind = array_search($row['numero_documento'], $arrNDoc);
                    $mass['rows'][$ind]['detalle'][] = array(
                                                        'name_producto'=>($row['name_producto']),
                                                        'desc_item_c'=>($row['desc_item_c']),
                                                        'valor_neto'=>round($row['valor_neto']),
                                                        'talla'=>($row['talla']),
                                                        'color'=>($row['color']),
                                                        'linea'=>($row['linea']),
                                                        'colecciones'=>($row['colecciones'])
                                                    );
                }
                
            }
            echo json_encode($mass);
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    
    /**
     * 
     * @return type
     * @throws Exception
     */
    public function action_getInfoCallcenter(){
        try{
            $db = DBManagerFactory::getInstance();
            $res = $db->query(
                "
                    SELECT 
                        colla.date_entered,
                        COALESCE(colla.proxima_llamada,'') as proxima_llamada,
                        COALESCE(opc.name,'Sin gestion') as gestion_name,
                        COALESCE(colla.hablo_con,'') as hablo_con,
                        COALESCE(colla.description,'') as description
                    FROM 
                        cont__centro_llamadas colla
                            INNER JOIN
                                cont__centro_llamadas_contacts_c contac ON
                                    colla.id = contac.cont__centro_llamadas_contactscont__centro_llamadas_idb
                            INNER JOIN
                                cont__opciones_respuestas opc ON
                                    colla.cont__opciones_respuestas_id_c = opc.id
                    WHERE 
                        colla.deleted = 0 AND
                        contac.cont__centro_llamadas_contactscontacts_ida = '".$_REQUEST['idcontactos']."'
                    ORDER BY
                        colla.date_entered DESC
                "
            );
            $mass = array('rows'=>array());
            $cont = 0;
            while ($row = $db->fetchByAssoc($res)) {
                $mass['rows'][$cont]['date_entered'] = $row['date_entered'];
                $mass['rows'][$cont]['proxima_llamada'] = $row['proxima_llamada'];
                $mass['rows'][$cont]['gestion_name'] = $row['gestion_name'];
                $mass['rows'][$cont]['hablo_con'] = $row['hablo_con'];
                $mass['rows'][$cont]['description'] = $row['description'];
                $cont++;
            }
            echo json_encode($mass);
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    /**
     * 
     * @throws Exception
     */
    public function action_saveGestionCallcenter(){
        $db = DBManagerFactory::getInstance();
        try{
            $_REQUEST['action'] = 'index';
            $db->query("BEGIN");
            if(isset($_REQUEST['hdnidcontacto']) && $_REQUEST['hdnidcontacto']!=""){
                // veriifcamos la opcion
                if($_REQUEST['selOpciones'] != ""){
                    if($_REQUEST['txtFechaProximaLlamada']!=""){
                        $ampm = substr($_REQUEST['txtFechaProximaLlamada'],strlen($_REQUEST['txtFechaProximaLlamada'])-5);
                        if($ampm == ' p.m.'){
                            $arrhora = explode(' ',$_REQUEST['txtFechaProximaLlamada']);
                            $hora = explode(':',$arrhora[1]);
                            $hora[0] = ($hora[0]+12); 
                            // aumentamos las horas
                            $_REQUEST['txtFechaProximaLlamada'] = $arrhora[0].' '.$hora[0].':'.$hora[1].':00';
                        }else{
                            $arrhora = explode(' ',$_REQUEST['txtFechaProximaLlamada']);
                            $hora = explode(':',$arrhora[1]);
                            if($hora[0] == 12){
                                $hora[0] = '00';
                            }
                            // aumentamos las horas
                            $_REQUEST['txtFechaProximaLlamada'] = $arrhora[0].' '.$hora[0].':'.$hora[1].':00';
                        }
                    }
                    // insertamos en centro llamadas
                    $idc = create_guid();
                    $date = @date('Y-m-d H:i:s');
                    $sql = "
                        INSERT INTO
                            cont__centro_llamadas(
                               id,
                               name,
                               date_entered,
                               created_by,
                               description,
                               hablo_con,
                               cont__opciones_respuestas_id_c,
                               proxima_llamada
                            )
                            VALUES(
                                '".$idc."',
                                '',
                                '".$date."',
                                '".$_SESSION['authenticated_user_id']."',
                                '".($_REQUEST['tarDescripcion'])."',
                                '".($_REQUEST['txtSeHabloCon'])."',
                                '".($_REQUEST['selOpciones'])."',
                                ".($_REQUEST['txtFechaProximaLlamada']!=""?'"'.$_REQUEST['txtFechaProximaLlamada'].'"':'NULL')."
                            )
                    ";
                    $resp = $db->query($sql);
                    // insertamos en centro llamada - contacto
                    $sql = "
                        INSERT INTO
                            cont__centro_llamadas_contacts_c(
                               id,
                               date_modified,
                               cont__centro_llamadas_contactscontacts_ida,
                               cont__centro_llamadas_contactscont__centro_llamadas_idb
                            )
                            VALUES(
                                '".create_guid()."',
                                '".$date."',
                                '".($_REQUEST['hdnidcontacto'])."',
                                '".($idc)."'
                            )
                    ";
                    $resp = $db->query($sql);

                    // verificamos si es necesario actualziar contactos
                    if($_REQUEST['selOpciones'] == '6ef81ab1-df63-cdfc-b26f-55d020bd466f'){
                        // actualizamos el donotcall
                        $sql = "
                            UPDATE
                                contacts
                            SET
                                date_modified = '".$date."',
                                modified_user_id = '".$_SESSION['authenticated_user_id']."',
                                do_not_call = 1
                            WHERE
                                id = '".$_REQUEST['hdnidcontacto']."'
                                 ";
                        $resp = $db->query($sql);
                    }
                    
                    //verificamos si es necesario actualizar todo los datos d contacto
                    if($_REQUEST['selOpciones'] == 'ef2cb3bd-2798-c655-3b2f-55f265e2aff4'){
                        
                        if(!$this->update_all_contact()){
                            $msj_s = "Error: Hay datos inconsistentes, la informacion de la opcion de gestion esta errada!";
                            $db->query("ROLLBACK");
                        }
                    }

                    $msj_s = "Proceso terminado correctamente, se ha creado una nueva gestion de CALLCENTER";
                    $db->query("COMMIT");
                }else{
                    $msj_s = "Error: Hay datos inconsistentes, la informacion de la opcion de gestion esta errada!";
                    $db->query("ROLLBACK");
                }
            }else{
                $msj_s = "Error: Hay datos inconsistentes, la informacion del contacto esta errada!";
                $db->query("ROLLBACK");
            }
            
            $this->action_listview();
            
            echo json_encode(array(
                "error"=>false,
                "msj"=>$msj_s
            ));
            exit;
        } catch (Exception $ex) {
            $db->query("ROLLBACK");
            throw $ex;
        }
    }
    
    /**
     * 
     * @return boolean
     * @throws Exception
     */
/**
 * Comienza adiciones Reportes Darwin-Carlos
 * Parte 2-3 ref.00001a
 */
    private function acomodarString($Arrdatos)
    {
        //cojemos el primer valor del arreglo y lo colocamos entere ^ ^ ya que asi lo entiende sugar 
        $nuevoinformacionTxt="^".$Arrdatos[0]."^";
        for ($i=0;$i<count($Arrdatos);$i++){
               
               /*luego si no vamos por el primer ciclo vamos concatenando cada item al string 
                  separandolo por una coma y añadiendo los ^ para que sugar lo entienda ya que 
                  sugar trabaja con esto ^
               */
               if($Arrdatos[0]!=$Arrdatos[$i]){
               $nuevoinformacionTxt.=",^".$Arrdatos[$i]."^";
               }
            }

       return $nuevoinformacionTxt;

    }
/*Se recibe el array del select selTipoInformacionMultiple y se le envia 
al metodo acomodarString x convertirlo en string y acomodarlo a sugar */
    private function update_all_contact(){
        
        
       //print_r($_REQUEST['selTipoInformacion']);
       $tipoinformaciones=$_REQUEST['selTipoInformacionMultiple'];

       $tipoinformacionTxt=$this->acomodarString($tipoinformaciones);

            
          //  echo $tipoinformacionTxt;

          
      try{

          
           
                        
            $db = DBManagerFactory::getInstance();

          

            $sql = "
                UPDATE
                    contacts
                SET
                    date_modified = '".$date."',
                    modified_user_id = '".$_SESSION['authenticated_user_id']."',
                    first_name = '".$_REQUEST['txtFirstName']."',
                    phone_home = '".$_REQUEST['txtTelCasa']."',
                    phone_mobile = '".$_REQUEST['txtTelCelu']."',
                    phone_work = '".$_REQUEST['txtTelTrabajo']."',
                    birthdate =  '".@date('Y')."-".str_pad($_REQUEST['selMesCumples'], 2, "0",STR_PAD_LEFT)."-".str_pad($_REQUEST['selDiaCumples'], 2, "0",STR_PAD_LEFT)."'
                WHERE
                    id = '".$_REQUEST['hdnidcontacto']."'
                     ";
            $resp = $db->query($sql);
            $sql = "
                UPDATE
                    contacts_cstm
                SET
                    cliente_vip_c = '".$_REQUEST['selVip']."',
                    cedula_nit_c = '".$_REQUEST['txtCedula']."',
                    mes_cumpleanos_c = '".$this->get_mes_spanish($_REQUEST['selMesCumples'])."',
                    frecuenciacontacto_c = '".$_REQUEST['selFrecuenciaContacto']."',
                    tipocontacto_c = '".$_REQUEST['selTipoContacto']."',
                    tipoinformacion_c = '".$_REQUEST['selTipoInformacionNormal']."',
                    tipoinformacionsm_c = '".$tipoinformacionTxt."'
                WHERE
                    id_c = '".$_REQUEST['hdnidcontacto']."'
                     ";
            $resp = $db->query($sql);
            
            
            // verificamos si hay q actualizar la tienda
            if($_REQUEST['selTienda']!=""){
                // verificamos si eexiste la relacion con - tienda
                $sql = "
                    SELECT
                        *
                    FROM
                        stu_tiendas_contacts_c
                    WHERE
                        stu_tiendas_contactscontacts_idb = '".$_REQUEST['hdnidcontacto']."' AND
                        deleted = 0
                        ";
                $res = $db->query($sql);
                while ($row = $this->bean->db->fetchByAssoc($res)) {
                    $mass[] = $row;
                }
                if(count($mass)>0){
                    // actualizamos
                    $sql = "
                        UPDATE
                            stu_tiendas_contacts_c
                        SET
                            stu_tiendas_contactsstu_tiendas_ida = '".$_REQUEST['selTienda']."'
                        WHERE
                            id = '".$mass[0]['id']."'
                    ";
                    $resp = $db->query($sql);
                }else{
                    //insertamos
                    $sql = "
                        INSERT INTO
                            stu_tiendas_contacts_c(
                                id,
                                date_modified,
                                stu_tiendas_contactsstu_tiendas_ida,
                                stu_tiendas_contactscontacts_idb
                            )
                            VALUES(
                                '".create_guid()."',
                                '".@date('Y-m-d H:i:s')."',
                                '".$_REQUEST['selTienda']."',
                                '".$_REQUEST['hdnidcontacto']."'
                            )
                    ";
                    $resp = $db->query($sql);
                }
            }
            // verificmaos email update
            
            
            
         if(isset($_REQUEST['txtEmailP'])){
             
                // verificamos si eexiste la relacion con - tienda
                $sql = "
                    SELECT
                        *
                    FROM
                        email_addr_bean_rel
                    WHERE
                        bean_id = '".$_REQUEST['hdnidcontacto']."' AND
                        deleted = 0 AND
                        bean_module = 'Contacts' AND
                        primary_address  = 1
                        ";
                $res = $db->query($sql);
                $mass = array();
                while ($row = $this->bean->db->fetchByAssoc($res)) {
                    $mass[] = $row;
                }
                
                
                
                
                if(count($mass)>0){
                    // actualizamos
                    $sql = "
                        UPDATE
                            email_addresses
                        SET
                            email_address = '".$_REQUEST['txtEmailP']."',
                            email_address_caps = '".strtoupper($_REQUEST['txtEmailP'])."'   
                        WHERE
                            id = '".$mass[0]['email_address_id']."'
                    ";
                    $resp = $db->query($sql);
                }else{
                    //insertamos
                    $em_c = create_guid();
                    $sql = "
                        INSERT INTO
                            email_addresses(
                                id,
                                date_created,
                                email_address,
                                email_address_caps
                            )
                            VALUES(
                                '".$em_c."',
                                '".@date('Y-m-d H:i:s')."',
                                '".$_REQUEST['txtEmailP']."',
                                '".strtoupper($_REQUEST['txtEmailP'])."'
                            )
                    ";
                    $resp = $db->query($sql);
                    //insertamos
                    $sql = "
                        INSERT INTO
                            email_addr_bean_rel(
                                id,
                                email_address_id,
                                bean_id,
                                bean_module,
                                primary_address,
                                date_created
                            )
                            VALUES(
                                '".create_guid()."',
                                '".$em_c."',
                                '".$_REQUEST['hdnidcontacto']."',
                                'Contacts',
                                '1',
                                '".@date('Y-m-d H:i:s')."'
                            )
                    ";
                    $resp = $db->query($sql);
                }
            }
            
            return true;
        } catch (Exception $ex) {
            throw $ex;
        }
        
    }
    
    /**
     * 
     * @throws Exception
     */
    public function action_getReportLlamadasTienda(){
        try{
            $db = DBManagerFactory::getInstance();
            
            // sacamos las opciones
            $res = $db->query("
                SELECT
                    name
                FROM
                    cont__opciones_respuestas
                WHERE
                    deleted = 0
                ORDER BY name ASC
            ");
            $arrOpc = array();
            while ($row = $db->fetchByAssoc($res)) {
                $arrOpc[] = $row['name'].'__opc';
            }
            
            // sacamos las tiendas
            $res = $db->query("
                SELECT
                    id,name
                FROM
                    stu_tiendas
                WHERE
                    deleted = 0
            ");
            $arrResp = array();
            $cont_general = 0;
            while ($row = $db->fetchByAssoc($res)) {
                $arrResp['rows'][$cont_general]['id'] = $row['id'];
                $arrResp['rows'][$cont_general]['name'] = $row['name'];
                $sql = "
                    SELECT
                        cenprin.*,
                        opc.name as name_opc
                    FROM
                        cont__centro_llamadas_contacts_c centro
                            INNER JOIN
                                (
                                    contacts cont 
                                        INNER JOIN
                                            stu_tiendas_contacts_c tiencon ON
                                                cont.id = tiencon.stu_tiendas_contactscontacts_idb
                                )
                                ON
                                    centro.cont__centro_llamadas_contactscontacts_ida = cont.id
                            INNER JOIN
                                (
                                    cont__centro_llamadas cenprin 
                                        INNER JOIN
                                            cont__opciones_respuestas opc ON
                                                cenprin.cont__opciones_respuestas_id_c = opc.id
                                )
                                    ON
                                    centro.cont__centro_llamadas_contactscont__centro_llamadas_idb = cenprin.id
                    WHERE
                        tiencon.stu_tiendas_contactsstu_tiendas_ida = '".$row['id']."' AND
                        cenprin.date_entered >= '".$_REQUEST['fecha_desde']." 00:00:00' AND
                        cenprin.date_entered <= '".$_REQUEST['fecha_hasta']." 23:59:59'
                         ";
                $res_g = $db->query($sql);
                $cont_g = 0;
                $cont_e = 0;
                // set arra opc
                for($i=0;$i<count($arrOpc);$i++){
                    $arrResp['rows'][$cont_general][$arrOpc[$i]] = 0;
                }
                while ($row_g = $db->fetchByAssoc($res_g)) {
                    $cont_g ++;
                    if($row_g['cont__opciones_respuestas_id_c'] == "2d86a2bd-08a4-3249-5a16-55d64dd70287" ||
                       $row_g['cont__opciones_respuestas_id_c'] == "adf18402-8e76-232d-77ba-55d64d73c332" ||
                       $row_g['cont__opciones_respuestas_id_c'] == "bd002e14-cb93-3f47-db8e-55d64d56bded" ||
                       $row_g['cont__opciones_respuestas_id_c'] == "ef2cb3bd-2798-c655-3b2f-55f265e2aff4"
                    ){
                        $cont_e ++;
                        //$arrResp['rows'][$cont_general][$row_g['name_opc'].'__efectiva'] = true;
                    }
                    $arrResp['rows'][$cont_general][$row_g['name_opc'].'__opc'] ++;
                }
                $arrResp['rows'][$cont_general]['total_llamadas'] = $cont_g;
                $arrResp['rows'][$cont_general]['total_llamadas_efectivas'] = $cont_e;
                $arrResp['rows'][$cont_general]['porcentaje'] = ($cont_e>0&&$cont_g>0?round(($cont_e*100/$cont_g),2):0);
                
                $cont_general++;
            }
            // verificamos si hay q exprotar
            if(!isset($_REQUEST['tipo'])){
                echo json_encode($arrResp);
            }else{
                $this->generaArchivo($arrResp,$_REQUEST['tipo'],array('total_llamadas','total_llamadas_efectivas'),"Reporte Llamadas por Tienda");
            }
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    
    /**
     * 
     * @throws Exception
     */
    public function action_getReportLlamadasOperador(){
        try{
            $db = DBManagerFactory::getInstance();
            // sacamos las opciones
            $res = $db->query("
                SELECT
                    name
                FROM
                    cont__opciones_respuestas
                WHERE
                    deleted = 0
                ORDER BY name ASC
            ");
            $arrOpc = array();
            while ($row = $db->fetchByAssoc($res)) {
                $arrOpc[] = $row['name'].'__opc';
            }
            
            
            // sacamos las tiendas
            $res = $db->query("
                SELECT
                    us.id,
                    us.user_name as name
                FROM
                    users us
                        INNER JOIN
                            acl_roles_users rol ON
                                us.id = rol.user_id
                WHERE
                    us.deleted = 0
            ");
            $arrResp = array();
            $cont_general = 0;
            while ($row = $db->fetchByAssoc($res)) {
                $arrResp['rows'][$cont_general]['id'] = $row['id'];
                $arrResp['rows'][$cont_general]['name'] = $row['name'];
                $sql = "
                    SELECT
                        cenprin.*,
                        opc.name as name_opc
                    FROM
                        cont__centro_llamadas cenprin
                            INNER JOIN
                                cont__opciones_respuestas opc ON
                                    cenprin.cont__opciones_respuestas_id_c = opc.id
                    WHERE
                        cenprin.created_by = '".$row['id']."' AND
                        cenprin.date_entered >= '".$_REQUEST['fecha_desde']." 00:00:00' AND
                        cenprin.date_entered <= '".$_REQUEST['fecha_hasta']." 23:59:59'
                         ";
                $res_g = $db->query($sql);
                $cont_g = 0;
                $cont_e = 0;
                // set arra opc
                for($i=0;$i<count($arrOpc);$i++){
                    $arrResp['rows'][$cont_general][$arrOpc[$i]] = 0;
                }
                while ($row_g = $db->fetchByAssoc($res_g)) {
                    $cont_g ++;
                    if($row_g['cont__opciones_respuestas_id_c'] == "2d86a2bd-08a4-3249-5a16-55d64dd70287" ||
                       $row_g['cont__opciones_respuestas_id_c'] == "adf18402-8e76-232d-77ba-55d64d73c332" ||
                       $row_g['cont__opciones_respuestas_id_c'] == "bd002e14-cb93-3f47-db8e-55d64d56bded" ||
                       $row_g['cont__opciones_respuestas_id_c'] == "ef2cb3bd-2798-c655-3b2f-55f265e2aff4"
                    ){
                        $cont_e ++;
                        //$arrResp['rows'][$cont_general][$row_g['name_opc'].'__efectiva'] = true;
                    }
                    $arrResp['rows'][$cont_general][$row_g['name_opc'].'__opc'] ++;
                }
                $arrResp['rows'][$cont_general]['total_llamadas'] = $cont_g;
                $arrResp['rows'][$cont_general]['total_llamadas_efectivas'] = $cont_e;
                $arrResp['rows'][$cont_general]['porcentaje'] = ($cont_e>0&&$cont_g>0?round(($cont_e*100/$cont_g),2):0);
                
                $cont_general++;
            }
            
            // verificamos si hay q exprotar
            if(!isset($_REQUEST['tipo'])){
                echo json_encode($arrResp);
            }else{
                $this->generaArchivo($arrResp,$_REQUEST['tipo'],array('total_llamadas','total_llamadas_efectivas'),"Reporte Llamadas por Operador");
            }
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    
    /**
     * 
     * @throws Exception
     */
    public function action_getReportLlamadasClientes(){
        try{
            $db = DBManagerFactory::getInstance();
            // sacamos las tiendas
            $res = $db->query("
                SELECT
                    tien.id,
                    tien.name,
                    COALESCE((
                        SELECT
                            COUNT(*)
                        FROM
                            stu_tiendas_contacts_c contiend
                                INNER JOIN
                                    contacts con ON
                                        contiend.stu_tiendas_contactscontacts_idb = con.id
                        WHERE
                            con.deleted = 0 AND
                            contiend.deleted = 0 AND
                            contiend.stu_tiendas_contactsstu_tiendas_ida = tien.id
                    ),0) as cantidad_clientes
                FROM
                    stu_tiendas tien
                WHERE
                    tien.deleted = 0
            ");
            $arrResp = array();
            $cont_general = 0;
            while ($row = $db->fetchByAssoc($res)) {
                $arrResp['rows'][$cont_general]['id'] = $row['id'];
                $arrResp['rows'][$cont_general]['name'] = $row['name'];
                $arrResp['rows'][$cont_general]['cantidad_clientes'] = $row['cantidad_clientes'];
                $sql = "
                  SELECT
                        COUNT(1) as contac
                    FROM
                        stu_tiendas_contacts_c contiend
                                INNER JOIN
                                    contacts con ON
                                        contiend.stu_tiendas_contactscontacts_idb = con.id
                                
                    WHERE
                        contiend.stu_tiendas_contactsstu_tiendas_ida = '".$row['id']."' AND
                        con.date_entered >= '".$_REQUEST['fecha_desde']." 00:00:00' AND
                        con.date_entered <= '".$_REQUEST['fecha_hasta']." 23:59:59' AND
                        con.deleted = 0                    
                         ";
                $res_g = $db->query($sql);
                $cont_g = 0;
                $cont_e = 0;
                $arrResp['rows'][$cont_general]['total_en_rango'] = 0;
                while ($row_g = $db->fetchByAssoc($res_g)) {
                    $arrResp['rows'][$cont_general]['total_en_rango'] = $row_g['contac'];
                }
                
                $cont_general++;
            }
            
            // verificamos si hay q exprotar
            if(!isset($_REQUEST['tipo'])){
                echo json_encode($arrResp);
            }else{
                $this->generaArchivo($arrResp,$_REQUEST['tipo'],array('cantidad_clientes','total_en_rango'),"Reporte de Clientes");
            }
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    
/**
 * Comienza adiciones Reportes Darwin-Carlos
 * Parte 3-3 ref.00001a
 */

    public function action_getReportCampanasClientes(){
        try{
            $db = DBManagerFactory::getInstance();
            // sacamos las tiendas
            $res = $db->query("
                SELECT
                    tien.id,
                    tien.name,
                    COALESCE((
                        SELECT
                            COUNT(*)
                        FROM
                            stu_tiendas_contacts_c contiend
                                INNER JOIN
                                    contacts con ON
                                        contiend.stu_tiendas_contactscontacts_idb = con.id
                                
                        WHERE
                            con.deleted = 0 AND
                            contiend.deleted = 0 AND
                            contiend.stu_tiendas_contactsstu_tiendas_ida = tien.id
                    ),0) as cantidad_clientes
                FROM
                    stu_tiendas tien
                WHERE
                    tien.deleted = 0
            ");
            $arrResp = array();
            $cont_general = 0;
            while ($row = $db->fetchByAssoc($res)) {
                $arrResp['rows'][$cont_general]['id'] = $row['id'];
                $arrResp['rows'][$cont_general]['name'] = $row['name'];
                $arrResp['rows'][$cont_general]['cantidad_clientes'] = $row['cantidad_clientes'];
                
                /*como todas estas busquedas manejan el mismo select 
                 * entonses creo solamente los where y luego se mandan 
                 * al metodo crearQueryBusqueda
                 */
                $whereTime = "
                        contiend.stu_tiendas_contactsstu_tiendas_ida = '".$row['id']."' AND
                        con.date_entered >= '".$_REQUEST['fecha_desde']." 00:00:00' AND
                        con.date_entered <= '".$_REQUEST['fecha_hasta']." 23:59:59' AND
                        con.deleted = 0                    
                         ";
               if($_REQUEST['tipocontacto_c']!="noTipo"){
               $whereTipo = "
                        contiend.stu_tiendas_contactsstu_tiendas_ida = '".$row['id']."' AND
                        con_cstm.tipocontacto_c = '".$_REQUEST['tipocontacto_c']."' AND
                        con.date_entered >= '".$_REQUEST['fecha_desde']." 00:00:00' AND
                        con.date_entered <= '".$_REQUEST['fecha_hasta']." 23:59:59' AND
                        con.deleted = 0                    
                         ";
                }

                if($_REQUEST['frecuenciacontacto_c']!="noFrecuencia"){
               $whereFrecuencia = "
                        contiend.stu_tiendas_contactsstu_tiendas_ida = '".$row['id']."' AND
                        con_cstm.frecuenciacontacto_c = '".$_REQUEST['frecuenciacontacto_c']."' AND
                        con.date_entered >= '".$_REQUEST['fecha_desde']." 00:00:00' AND
                        con.date_entered <= '".$_REQUEST['fecha_hasta']." 23:59:59' AND
                        con.deleted = 0                    
                         ";
                 }
               if($_REQUEST['tipoinformacionsm_c']!="noSelTipo"){
               $whereTipoInformacion = "
                        contiend.stu_tiendas_contactsstu_tiendas_ida = '".$row['id']."' AND
                        con_cstm.tipoinformacion_c = '".$_REQUEST['tipoinformacionsm_c']."' AND
                        con.date_entered >= '".$_REQUEST['fecha_desde']." 00:00:00' AND
                        con.date_entered <= '".$_REQUEST['fecha_hasta']." 23:59:59' AND
                        con.deleted = 0                    
                         ";
                   }
                
                
                /*
                 * lo siguiente lo que hace es devolver la cantidad y asignarla al indice
                 * del array correspondiente 
                 * 
                 */
                if(!isset($_REQUEST['tipo'])){
               $arrResp['rows'][$cont_general]['total_en_fecha'] = $this->crearQueryBusqueda($whereTime);
                }
                if($_REQUEST['tipocontacto_c']!="noTipo"){
                $arrResp['rows'][$cont_general]['total_en_tipo'] = $this->crearQueryBusqueda($whereTipo);
                }
                else{
                $arrResp['rows'][$cont_general]['total_en_tipo'] = "0";
                }
                 if($_REQUEST['frecuenciacontacto_c']!="noFrecuencia"){
                $arrResp['rows'][$cont_general]['total_en_periodo'] = $this->crearQueryBusqueda($whereFrecuencia);
                }
                else{
                $arrResp['rows'][$cont_general]['total_en_periodo'] = "0";
                }
                 if($_REQUEST['tipoinformacionsm_c']!="noSelTipo"){
                $arrResp['rows'][$cont_general]['total_en_informacion'] = $this->crearQueryBusqueda($whereTipoInformacion);
                }
                else{
                $arrResp['rows'][$cont_general]['total_en_informacion'] = "0";
                }
                
                
                
                $cont_general++;
            }
            
            // verificamos si hay q exprotar
            if(!isset($_REQUEST['tipo'])){
                echo json_encode($arrResp);
            }else{

                $this->generaArchivo($arrResp,$_REQUEST['tipo'],array('cantidad_clientes','total_en_tipo','total_en_periodo','total_en_informacion'),"Reporte de Clientes");
            }
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    
    /* inputs 
     * $where=a qui se envia el where con el parametro 
     * que se quiere buscar 
     * ouputs 
     * retorna la cantidad segun por el parametro 
     * establecido
     */
    
    private function crearQueryBusqueda($where){
                $db = DBManagerFactory::getInstance();
                /*como se puede observar se crea el select y se le añade el
                 * where con el x parametro a busca 
                 */
                $sql="
                          SELECT
                                COUNT(1) as contac
                            FROM
                                stu_tiendas_contacts_c contiend
                                        INNER JOIN
                                            contacts con ON
                                                contiend.stu_tiendas_contactscontacts_idb = con.id
                                        INNER JOIN 
                                            contacts_cstm con_cstm ON
                                                       contiend.stu_tiendas_contactscontacts_idb=con_cstm.id_c


                            WHERE ".$where;

                 $res_g = $db->query($sql);
                 $total=0;
                        while ($row_g = $db->fetchByAssoc($res_g)) {
                           $total = $row_g['contac'];
                        }
                 return $total;
        }

        /**
/*Finaliza Parte 3-3 ref.00001a*/
     /*
     * 
     * @param type $arrDatos
     * @param type $tipo
     * @throws Exception
     */
    private function generaArchivo($arrDatos,$tipo,$arrTotales,$title){
        try{
            if($tipo == 'xlsx'){
                $ruta_f = $this->getFileXlsx($arrDatos,$arrTotales);
            }else{
                if($tipo == 'pdf'){
                    $ruta_f = $this->getFilePdf($arrDatos,$arrTotales,$title);
                }
            }
            echo json_encode(array(
                "error"=>false,
                "archivo_url"=>$ruta_f
            ));
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    
    private function getFileXlsx($arrDatos,$arrTotales){
        try{
            require_once("include/PHPExcel-1.8/Classes/PHPExcel/IOFactory.php");
            $objPHPExcel = new PHPExcel();
            $arrLetras = array("A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P");
            if(isset($arrDatos['rows'])){
                $cont = 0;
                foreach ($arrDatos['rows'][0] as $key => $value) {
                    if($key == "id"){
                        continue;
                    }
                    //echo '==>'.print_r($key,true);
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($arrLetras[$cont]."1", $key);
                    $cont++;
                }
                
                $cont_r = 1;
                // set body archivo
                foreach ($arrDatos['rows'] as $key => $value) {
                    $cont_c = 0;
                    foreach ($value as $key_2 => $value_2) {
                        if($key_2 == "id"){
                            continue;
                        }
                        // Miscellaneous glyphs, UTF-8
                        $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($arrLetras[$cont_c].($cont_r+1),$value_2);
                        
                        $cont_c ++;;
                    }
                    $cont_r ++;
                }
            }
            // Rename worksheet
            $objPHPExcel->getActiveSheet()->setTitle('Datos reporte');
            // Set active sheet index to the first sheet, so Excel opens this as the first sheet
            $objPHPExcel->setActiveSheetIndex(0);
            // Save Excel 2007 file
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            
            $ruta_f = "/tmpimagenes/reportes/xlsx/";
            $ruta_file = __FILE__;
            //echo $ruta_file;
            $ruta_file = substr($ruta_file,0,strpos($ruta_file,"modules")).$ruta_f;
            $n_archivo = 'reportcallcenter_'.@date('YmdHis').".xlsx";
            
            $objWriter->save($ruta_file."/".$n_archivo);
            
            $link_url = 'http' . (isset($_SERVER['HTTPS']) ? 's' : '') . '://' . $_SERVER['HTTP_HOST']."/".$_SERVER['REQUEST_URI'];
            $link_url = substr($link_url,0,strpos($link_url,'index'));
                    
            return $link_url.$ruta_f."/".$n_archivo;
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    
    private function getFilePdf($arrDatos,$arrTotales,$title){
        try{
            require_once('include/Sugarpdf/Sugarpdf.php');
            $sugarpdf = new Sugarpdf();
            $sugarpdf->AddPage();
            $sugarpdf->SetFont(K_PATH_FONTS.PDF_FONT_NAME_MAIN,'',PDF_FONT_SIZE_MAIN);
            $sugarpdf->Ln(4);
            
            $link_url = 'http' . (isset($_SERVER['HTTPS']) ? 's' : '') . '://' . $_SERVER['HTTP_HOST']."/".$_SERVER['REQUEST_URI'];
            $link_url = substr($link_url,0,strpos($link_url,'index'));
            //echo $link_url."custom/themes/default/images/company_logo.png";exit;
            $str = '<table width="100%" style="witdh:100%;">';
            $str .= "   <tr>";
            $str .= '       <th width="400" style="width:60%;">';
            $str .= '           <img src="'.$link_url.'custom/themes/default/images/company_logo.png" />';
            $str .= "       </th>";
            $str .= '       <th width="100" style="width:40%;">';
            $str .= "           Archivo generado:<br/>".@date('Y-m-d H:i:s');
            $str .= "           <br/>";
            $str .= "           <br/>";
            $str .= "           Rango:<br/>".$_REQUEST['fecha_desde']." a ".$_REQUEST['fecha_hasta'];
            $str .= "       </th>";
            $str .= "   </tr>";
            $str .= "</table>";
            
            $str .= "<br/>";
            
            $str .= '<table width="100%" style="witdh:100%;">';
            $str .= "   <tr>";
            $str .= '       <th width="200" style="font-size:large;text-align;center;">&nbsp;</th>';
            $str .= '       <th width="400" style="font-size:large;text-align;center;"><center>'.$title.'</center></th>';
            $str .= "   </tr>";
            $str .= "</table>";
            
            $str .= '<table border=1 style="witdh:100%;" cellspacing="0" cellpadding="0">';
            if(isset($arrDatos['rows'])){
                $cont = 0;
                $str .= "<tr>";
                foreach ($arrDatos['rows'][0] as $key => $value) {
                    if($key == "id"){
                        continue;
                    }
                    //add a display page
                    $str .= '<th style="border-style:solid;border-width:1px;font-size:x-small;background-color:#F8F7FA;">&nbsp;'.strtoupper(str_replace("__opc","",$key)).'&nbsp;</th>';
                    $cont++;
                }
                $str .= "</tr>";
                $cont_r = 1;
                // set body archivo
                $arrTotal = array();
                foreach ($arrDatos['rows'] as $key => $value) {
                    $cont_c = 0;
                    $str .= "<tr>";
                    foreach ($value as $key_2 => $value_2) {
                        if($key_2 == "id"){
                            continue;
                        }
                        if(count($arrTotales)>0){
                            if(in_array($key_2, $arrTotales)){
                                if(!array_key_exists($key_2,$arrTotal)){
                                    $arrTotal[$key_2] = $value_2;
                                }else{
                                    $arrTotal[$key_2] += $value_2;
                                }
                            }else{
                                $arrTotal[$key_2] = "&nbsp;";
                            }
                        }
                        //add a display page
                        if(is_numeric($value_2)){
                            $str .= '<td style="border-style:solid;border-width:1px;font-size:xx-medium;font-family:verdana;">&nbsp;'.number_format($value_2).'&nbsp;</td>';
                        }else{
                            $str .= '<td style="border-style:solid;border-width:1px;font-size:xx-medium;font-family:verdana;">&nbsp;'.($value_2).'&nbsp;</td>';
                        }
                        $cont_c ++;;
                    }
                    $sugarpdf->Ln();
                    $cont_r ++;
                    $str .= "</tr>";
                }
                // set totales
                if(count($arrTotales)>0){
                    $str .= "<tr>";
                    foreach ($arrTotal as $key => $value) {
                        if(is_numeric($value)){
                            $str .= '<td style="color:red;border-style:solid;border-width:1px;font-size:large;background-color:#F8F7FA;">&nbsp;'.number_format($value).'&nbsp;</td>';
                        }else{
                            $str .= '<td style="background-color:#F8F7FA;">'.($value).'</td>';
                        }
                    }
                    $str .= "</tr>";
                }
            }
            
            $str .= "</table>";
            $sugarpdf->writeHTML($str);
            // set name
            $ruta_f = "/tmpimagenes/reportes/pdf/";
            $ruta_file = __FILE__;
            //echo $ruta_file;
            $ruta_file = substr($ruta_file,0,strpos($ruta_file,"modules")).$ruta_f;
            $n_archivo = 'reportcallcenter_'.@date('YmdHis').".pdf";
            
            $sugarpdf->Output($ruta_file."/".$n_archivo,"F");
            
            $link_url = 'http' . (isset($_SERVER['HTTPS']) ? 's' : '') . '://' . $_SERVER['HTTP_HOST']."/".$_SERVER['REQUEST_URI'];
            $link_url = substr($link_url,0,strpos($link_url,'index'));
                    
            return $link_url.$ruta_f."/".$n_archivo;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    private function get_mes_spanish($mes){
        try{
            switch($mes){
                case "1":return "enero";
                case "2":return "febrero";
                case "3":return "marzo";
                case "4":return "abril";
                case "5":return "mayo";
                case "6":return "junio";
                case "7":return "julio";
                case "8":return "agosto";
                case "9":return "septiembre";
                case "10":return "octubre";
                case "11":return "noviembre";
                case "12":return "diciembre";
            }
        } catch (Exception $ex) {
            throw $ex;
        }
    }
}
?> 
