/* Agregar un nuevo evento a cualquier elemento */
function nuevoEvento(elemento, evento, funcion) {
    // para cualquier navegador
    try {
        if (elemento.addEventListener)
            elemento.addEventListener(evento, funcion, false);
         // para IE
         else
             elemento.attachEvent("on" + evento, funcion);
     } catch(e) {
         alert("No se pudo agregar el evento\n" + e.name + " - " + e.message);
     }
}
//create function, it expects 2 values.
function insertAfter(newElement,targetElement) {
    //target is what you want it to go after. Look for this elements parent.
    var parent = targetElement.parentNode;

    //if the parents lastchild is the targetElement...
    if(parent.lastchild == targetElement) {
        //add the newElement after the target element.
        parent.appendChild(newElement);
    } else {
        // else the target has siblings, insert the new element between the target and it's next sibling.
        parent.insertBefore(newElement, targetElement.nextSibling);
    }
}
// acomodar fechas //
function fnGetIntFecha(obj){
    var anio = obj.value.substring(6);
    var mes = obj.value.substring(0,2);
    var aux = obj.value.substring(3);
    var dia = aux.substring(0,2);
    
    return anio+mes+dia;
}
// fecha actual //
function get_now(){
    var f = new Date();
    return (((f.getMonth()+1)<10?'0'+(f.getMonth()+1):(f.getMonth()+1))) + "/" + (f.getDate()<10?'0'+f.getDate():f.getDate()) + "/" + f.getFullYear();
}

// *** //
function fn_utilidades_validate_gea_Callcenter(){
    var f_ini = fnGetIntFecha(document.getElementById('start_range_proxima_llamada_c_basic'));
    var f_fin = fnGetIntFecha(document.getElementById('end_range_proxima_llamada_c_basic'));

    var h_a = '';
    var m_a = '';
    var s_a = '';
    var h_e = '';
    var m_e = '';
    var s_e = '';
    if(document.getElementById('start_proxima_llamada_c_basic_hours')){
        h_a = document.getElementById('start_proxima_llamada_c_basic_hours').value;
    }
    if(document.getElementById('start_proxima_llamada_c_basic_minutes')){
        m_a = document.getElementById('start_proxima_llamada_c_basic_minutes').value;
    }
    if(document.getElementById('start_proxima_llamada_c_basic_seconds')){
        s_a = document.getElementById('start_proxima_llamada_c_basic_seconds').value;
    }
    // +++ //
    if(document.getElementById('end_proxima_llamada_c_basic_hours')){
        h_e = document.getElementById('end_proxima_llamada_c_basic_hours').value;
    }
    if(document.getElementById('end_proxima_llamada_c_basic_minutes')){
        m_e = document.getElementById('end_proxima_llamada_c_basic_minutes').value;
    }
    if(document.getElementById('end_proxima_llamada_c_basic_seconds')){
        s_e = document.getElementById('end_proxima_llamada_c_basic_seconds').value;
    }
    // *** //
    // validamos calendarios //
    if(f_ini=='' || f_fin==''){
        return;
    }
    if(parseInt(f_ini+''+h_a+''+m_a+''+s_a) > parseInt(f_fin+''+h_e+''+m_e+''+s_e)){
        alert('La fecha INICIAL debe ser menor que la fecha FINAL');
        document.getElementById('start_range_proxima_llamada_c_basic').value = '';
        document.getElementById('end_range_proxima_llamada_c_basic').value = '';
        if(document.getElementById('start_proxima_llamada_c_basic_hours')){
            document.getElementById('start_proxima_llamada_c_basic_hours').value = '00';
        }
        if(document.getElementById('start_proxima_llamada_c_basic_minutes')){
            document.getElementById('start_proxima_llamada_c_basic_minutes').value = '00';
        }
        if(document.getElementById('start_proxima_llamada_c_basic_seconds')){
            document.getElementById('start_proxima_llamada_c_basic_seconds').value = '00';
        }
        // +++ //
        if(document.getElementById('end_proxima_llamada_c_basic_hours')){
            document.getElementById('end_proxima_llamada_c_basic_hours').value = '00';
        }
        if(document.getElementById('end_proxima_llamada_c_basic_minutes')){
            document.getElementById('end_proxima_llamada_c_basic_minutes').value = '00';
        }
        if(document.getElementById('end_proxima_llamada_c_basic_seconds')){
            document.getElementById('end_proxima_llamada_c_basic_seconds').value = '00';
        }
    }
}
function serialize(form) {
	if (!form || form.nodeName !== "FORM") {
		return;
	}
	var i, j, q = [];
	for (i = form.elements.length - 1; i >= 0; i = i - 1) {
		if (form.elements[i].name === "") {
			continue;
		}
		switch (form.elements[i].nodeName) {
		case 'INPUT':
			switch (form.elements[i].type) {
			case 'text':
			case 'hidden':
			case 'password':
			case 'button':
			case 'reset':
			case 'submit':
				q.push(form.elements[i].name + "=" + encodeURIComponent(form.elements[i].value));
				break;
			case 'checkbox':
			case 'radio':
				if (form.elements[i].checked) {
					q.push(form.elements[i].name + "=" + encodeURIComponent(form.elements[i].value));
				}						
				break;
			case 'file':
				break;
			}
			break;			 
		case 'TEXTAREA':
			q.push(form.elements[i].name + "=" + encodeURIComponent(form.elements[i].value));
			break;
		case 'SELECT':
			switch (form.elements[i].type) {
			case 'select-one':
				q.push(form.elements[i].name + "=" + encodeURIComponent(form.elements[i].value));
				break;
			case 'select-multiple':
				for (j = form.elements[i].options.length - 1; j >= 0; j = j - 1) {
					if (form.elements[i].options[j].selected) {
						q.push(form.elements[i].name + "=" + encodeURIComponent(form.elements[i].options[j].value));
					}
				}
				break;
			}
			break;
		case 'BUTTON':
			switch (form.elements[i].type) {
			case 'reset':
			case 'submit':
			case 'button':
				q.push(form.elements[i].name + "=" + encodeURIComponent(form.elements[i].value));
				break;
			}
			break;
		}
	}
	return q.join("&");
}