/**
 * plugin.js
 * 
 * (c) Thomas Eitzenberger, thomas@eitzen.at
 * License: AGPL v3
 */

/* global tinymce:true */

// this function can get called from the plugin in init (above) or from the
// callback on advlink/advimg plugins..
// in the latter case, win and type will be set.. In the first case, we will just
// update the main editor window with the path of the uploaded file
function openmanager(field_name, url, type, win) {
  // get the path to the uploader plugin
  var strPluginPath = tinyMCE.activeEditor.plugins.openmanager.getPluginURL();
  // the path to the uplaoder script
  var strUploaderURL = strPluginPath + "/index.php"; // generate
  // the relative upload path
  var strUploadPath = encodeURI(tinyMCE.activeEditor.getParam('open_manager_upload_path')); // get

  // were called without any GET params
  if (strUploaderURL.indexOf("?") < 0) // if we
    strUploaderURL = strUploaderURL + "?type=" + type + "&d=" + strUploadPath; 

  // else add our own params
  else
    strUploaderURL = strUploaderURL + "&type=" + type + "&d=" + strUploadPath;

  // open the plugin popup
  tinyMCE.activeEditor.windowManager.open({ 
    file : strUploaderURL,
    title : 'Open Manager',
    width : 720,
    height : 450,
    resizable : "no",
    inline : 1, // This parameter only has an effect if you
    // use the inlinepopups plugin!
    close_previous : "no"
  }, {
    window : win,
    input : field_name
  });

  return false;
}

tinymce.PluginManager.add('openmanager', function(editor, url) {
  function openmanagerdlg() {

    editor.windowManager.open({
      title : 'TinyMCE site',
      url : url + '/index.php?d=' + encodeURI(tinyMCE.activeEditor.getParam('open_manager_upload_path')),
      width : 720 + parseInt(editor.getLang('openmanager.delta_width', 0)),
      height : 450 + parseInt(editor.getLang('openmanager.delta_height', 0)),
    }, {
      plugin_url : url, // Plugin absolute URL
      some_custom_arg : 'custom arg' // Custom argument
    });
  }

  editor.addCommand('mceElvtImage', openmanagerdlg);

  editor.addButton('openmanager', {
    icon : 'save',
    text : 'Files',
    context : 'file',
    cmd : 'mceElvtImage',
    disabled : false
  });

  editor.addShortcut('ctrl+s', '', 'mceElvtImage');

  console.log("added openmanager");
});